# Change Log

All notable changes to this project will be documented in this file.
See [Conventional Commits](https://conventionalcommits.org) for commit guidelines.

<a name="4.34.0"></a>
# [4.34.0](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@4.33.1...@progress/kendo-theme-bootstrap@4.34.0) (2021-04-16)


### Bug Fixes

* **adaptive:** use component and app colors for adaptive styling ([b38436e](https://github.com/telerik/kendo-themes/commit/b38436e))
* **appbar:** use light and dark colors for light and dark appbar ([3346deb](https://github.com/telerik/kendo-themes/commit/3346deb))
* **calendar:** update calendar colors to match latest design spec ([fdfc48c](https://github.com/telerik/kendo-themes/commit/fdfc48c))
* **color-system:** update selected hover colors ([d2daeaa](https://github.com/telerik/kendo-themes/commit/d2daeaa))
* **dataviz:** use linked chart colors for crosshair ([a7a9313](https://github.com/telerik/kendo-themes/commit/a7a9313))
* **drawer:** use component- variables for drawer styles ([60d11b6](https://github.com/telerik/kendo-themes/commit/60d11b6))
* **filter:** use subtle text variable for filter styling ([2eba3f6](https://github.com/telerik/kendo-themes/commit/2eba3f6))
* **grid:** filter menu items spacings ([02e2f54](https://github.com/telerik/kendo-themes/commit/02e2f54))
* **grid:** use correct colors for grid colum menu styles ([fc1f85c](https://github.com/telerik/kendo-themes/commit/fc1f85c))
* **loader:** use component- variables for loader styles ([d2a9808](https://github.com/telerik/kendo-themes/commit/d2a9808))
* **pivotgrid:** use correct colors for pivotgrid ([4dd2df2](https://github.com/telerik/kendo-themes/commit/4dd2df2))
* **splitter:** tweak splitbar colors ([9b978ef](https://github.com/telerik/kendo-themes/commit/9b978ef))
* **spreadsheet:** use component- variables for spreadsheet styles ([fb20ad7](https://github.com/telerik/kendo-themes/commit/fb20ad7))
* **timepicker:** align timepicker colors to design spec ([ec115cc](https://github.com/telerik/kendo-themes/commit/ec115cc))
* **upload:** use component- variables for upload styles ([b814610](https://github.com/telerik/kendo-themes/commit/b814610))


### Features

* **action-sheet:** add styles for action sheet ([a6fc80c](https://github.com/telerik/kendo-themes/commit/a6fc80c))
* **panelbar:** styles update ([613d2a3](https://github.com/telerik/kendo-themes/commit/613d2a3))
* **scheduler:** add year view styles ([96647f1](https://github.com/telerik/kendo-themes/commit/96647f1)), closes [#2229](https://github.com/telerik/kendo-themes/issues/2229)
* **skeleton:** component styles ([3a31ce0](https://github.com/telerik/kendo-themes/commit/3a31ce0))
* add styles for drag cell ([35c043b](https://github.com/telerik/kendo-themes/commit/35c043b))
* add TaskBoard styles ([fe98511](https://github.com/telerik/kendo-themes/commit/fe98511))
* increase contrast of textual colors ([da847d9](https://github.com/telerik/kendo-themes/commit/da847d9))
* ligthen base-bg in default theme ([256a23d](https://github.com/telerik/kendo-themes/commit/256a23d))
* **button:** align button colors to design specification ([1d40910](https://github.com/telerik/kendo-themes/commit/1d40910))
* **button:** update button spacing ([b539940](https://github.com/telerik/kendo-themes/commit/b539940))




<a name="4.33.1"></a>
## [4.33.1](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@4.33.0...@progress/kendo-theme-bootstrap@4.33.1) (2021-03-29)


### Bug Fixes

* update focus state ([89d9020](https://github.com/telerik/kendo-themes/commit/89d9020))
* update grid sticky columns/rows styling ([4e86821](https://github.com/telerik/kendo-themes/commit/4e86821))




<a name="4.33.0"></a>
# [4.33.0](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@4.32.0...@progress/kendo-theme-bootstrap@4.33.0) (2021-03-15)


### Features

* **grid:** update filter menu styles based on latest design ([ae4785e](https://github.com/telerik/kendo-themes/commit/ae4785e))
* add styles for action buttons with stretched layout in window and dialog ([810c300](https://github.com/telerik/kendo-themes/commit/810c300))




<a name="4.32.0"></a>
# [4.32.0](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@4.31.0...@progress/kendo-theme-bootstrap@4.32.0) (2021-03-04)


### Bug Fixes

* **bootstrap-theme:** replace usages of darken with shade ([96af7b6](https://github.com/telerik/kendo-themes/commit/96af7b6))
* **breadcrumb:** update breadcrumb styling to match in material and bootstrap design ([5965c1d](https://github.com/telerik/kendo-themes/commit/5965c1d))
* **calendar:** use subtle-text variable for calendar styles ([61099cd](https://github.com/telerik/kendo-themes/commit/61099cd))
* **colorpicker:** use correct styling for colorpicker interactive states ([0131f19](https://github.com/telerik/kendo-themes/commit/0131f19))
* **colorpicker:** use subtle text variable in colorpicker styling ([e8df2cf](https://github.com/telerik/kendo-themes/commit/e8df2cf))
* **combobox:** use correct styling for combobox interactive states ([9702a14](https://github.com/telerik/kendo-themes/commit/9702a14))
* **datetime:** use correct styling for datetime buttons interactive states ([f9be1ba](https://github.com/telerik/kendo-themes/commit/f9be1ba))
* **dragdrop:** remove duplicated drag drop styles ([560c8eb](https://github.com/telerik/kendo-themes/commit/560c8eb))
* **forms:** apply max-width to form-field-wrap ([bee6f6d](https://github.com/telerik/kendo-themes/commit/bee6f6d))
* **image-editor:** reduce colors used by image editor ([0860168](https://github.com/telerik/kendo-themes/commit/0860168))
* **multiselect:** use corect colors for multiselect in material theme ([9999811](https://github.com/telerik/kendo-themes/commit/9999811))
* **numeric:** use correct styling for numeric buttons interactive states ([1aa2a5d](https://github.com/telerik/kendo-themes/commit/1aa2a5d))
* **numerictextbox:** apply correct min-width to spinner buttons ([0bf02b8](https://github.com/telerik/kendo-themes/commit/0bf02b8))
* **rating:** use subtle-text variable for rating styling ([47f7a42](https://github.com/telerik/kendo-themes/commit/47f7a42))
* **scheduler:** use subtle-text variable in scheduler styling ([48be667](https://github.com/telerik/kendo-themes/commit/48be667))
* **stepper:** use subtle-text and disabled-text variables for stepper styling ([0d140ad](https://github.com/telerik/kendo-themes/commit/0d140ad))
* **switch:** update switch styles to match material and boostrap designs ([61129a3](https://github.com/telerik/kendo-themes/commit/61129a3))
* **switch:** use current width for thumb left position ([4456d85](https://github.com/telerik/kendo-themes/commit/4456d85))
* **tabstrip:** use subtle-text variable for tabstrip styling ([eb2347b](https://github.com/telerik/kendo-themes/commit/eb2347b))
* use subtle-text variable for forms and input styling ([0c49b7e](https://github.com/telerik/kendo-themes/commit/0c49b7e))
* **upload:** use subtle-text variable for upload styling ([8fa18b6](https://github.com/telerik/kendo-themes/commit/8fa18b6))
* add styles for content focus TabStrip and Wizard telerik/kendo[#12197](https://github.com/telerik/kendo-themes/issues/12197) ([5f9d382](https://github.com/telerik/kendo-themes/commit/5f9d382))
* use subtle-text variable for styling cards and chat components ([1d2728b](https://github.com/telerik/kendo-themes/commit/1d2728b))
* **upload:** remove redundant color variables ([74cd4a5](https://github.com/telerik/kendo-themes/commit/74cd4a5))


### Features

* add subtle text variable to be used as secondary text ([8b9322f](https://github.com/telerik/kendo-themes/commit/8b9322f))




<a name="4.31.0"></a>
# [4.31.0](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@4.30.0...@progress/kendo-theme-bootstrap@4.31.0) (2021-02-15)


### Bug Fixes

* **stepper:** Stepper uses progressbar element but does not include the progressbar styling ([b1ece1c](https://github.com/telerik/kendo-themes/commit/b1ece1c))


### Features

* **notification:** generate notification-themes map dynamically ([485f9a3](https://github.com/telerik/kendo-themes/commit/485f9a3))
* **overlay:** extract overlay as a separate component ([0e596ab](https://github.com/telerik/kendo-themes/commit/0e596ab))
* **utils:** add border width utility classnames ([69ac5c7](https://github.com/telerik/kendo-themes/commit/69ac5c7))
* update styles to match the new design ([45b4abc](https://github.com/telerik/kendo-themes/commit/45b4abc))




<a name="4.30.0"></a>
# [4.30.0](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@4.29.0...@progress/kendo-theme-bootstrap@4.30.0) (2021-01-13)


### Bug Fixes

* use correct value for Bootstrap SM spacing ([1751b03](https://github.com/telerik/kendo-themes/commit/1751b03))
* **chart:** inherit pane title font ([7db96ca](https://github.com/telerik/kendo-themes/commit/7db96ca))


### Features

* add $chart-pane-title-font-weight variable ([2daf251](https://github.com/telerik/kendo-themes/commit/2daf251))




<a name="4.29.0"></a>
# [4.29.0](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@4.28.0...@progress/kendo-theme-bootstrap@4.29.0) (2021-01-07)


### Bug Fixes

* clear-value icon wrong width ([acb7266](https://github.com/telerik/kendo-themes/commit/acb7266))
* missing clear button focus state ([26eab30](https://github.com/telerik/kendo-themes/commit/26eab30))
* **chart:** set area opacity to 0.6 ([e1fc2c4](https://github.com/telerik/kendo-themes/commit/e1fc2c4))
* **grid:** add styles for focused column menu button ([0ab43e9](https://github.com/telerik/kendo-themes/commit/0ab43e9))
* **grid:** import textbox as a dependency ([0adbaa1](https://github.com/telerik/kendo-themes/commit/0adbaa1))
* **toolbar:** splitbutton in overflow should display its items vertically ([9157d1f](https://github.com/telerik/kendo-themes/commit/9157d1f))


### Features

* **chart:** add default inactive opacity for area series ([6f3a175](https://github.com/telerik/kendo-themes/commit/6f3a175))
* **chart:** add default inactive opacity for line series ([156d38c](https://github.com/telerik/kendo-themes/commit/156d38c))
* **chart:** new series colors ([706f02b](https://github.com/telerik/kendo-themes/commit/706f02b))
* **utils:** add utility classes for order ([6221ba1](https://github.com/telerik/kendo-themes/commit/6221ba1))
* **utils:** add utility classes for overflow ([953ea45](https://github.com/telerik/kendo-themes/commit/953ea45))
* **utils:** add utility classes for pointer events ([46fa35e](https://github.com/telerik/kendo-themes/commit/46fa35e))
* **utils:** add utility classes for resizing textarea ([126ac02](https://github.com/telerik/kendo-themes/commit/126ac02))
* **utils:** add utility classes for touch action ([025d5c0](https://github.com/telerik/kendo-themes/commit/025d5c0))
* **utils:** add utility classes for user select ([0dc3da8](https://github.com/telerik/kendo-themes/commit/0dc3da8))




<a name="4.28.0"></a>
# [4.28.0](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@4.27.0...@progress/kendo-theme-bootstrap@4.28.0) (2020-12-21)


### Bug Fixes

* **checkbox:** improve spacing between checkbox list items ([7e244a0](https://github.com/telerik/kendo-themes/commit/7e244a0))
* **fab:** add disabled focus shadow ([f659ec5](https://github.com/telerik/kendo-themes/commit/f659ec5))
* **fab:** add lower elevation of the FAB in Default and Bootstrap themes ([e05d9e1](https://github.com/telerik/kendo-themes/commit/e05d9e1))
* **multiviewcalendar:** view header misalignment ([94714b5](https://github.com/telerik/kendo-themes/commit/94714b5))
* **radio:** improve spacing between radio list items ([8a168ec](https://github.com/telerik/kendo-themes/commit/8a168ec))
* reduce expander content padding ([2c53d13](https://github.com/telerik/kendo-themes/commit/2c53d13))
* separator wrong color ([04f5a39](https://github.com/telerik/kendo-themes/commit/04f5a39))


### Features

* **slider:** introduce slider custom properties (css vars) ([6121f38](https://github.com/telerik/kendo-themes/commit/6121f38))




<a name="4.27.0"></a>
# [4.27.0](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@4.26.0...@progress/kendo-theme-bootstrap@4.27.0) (2020-12-15)


### Bug Fixes

* **fab:** constrain circle and square shapes in size ([a06627e](https://github.com/telerik/kendo-themes/commit/a06627e))
* **scrollview:** update styles based on latest design ([ba5a4e9](https://github.com/telerik/kendo-themes/commit/ba5a4e9))


### Features

* **card:** focus styles ([dbca46b](https://github.com/telerik/kendo-themes/commit/dbca46b))
* **timeline:** focus styles ([ee8453f](https://github.com/telerik/kendo-themes/commit/ee8453f))




<a name="4.26.0"></a>
# [4.26.0](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@4.25.0...@progress/kendo-theme-bootstrap@4.26.0) (2020-12-10)


### Bug Fixes

* **fab:** line height issue in material and bootstrap themes ([80f03e3](https://github.com/telerik/kendo-themes/commit/80f03e3))
* **fab:** remove focus outline and add box-sizing to item icons ([f07f5da](https://github.com/telerik/kendo-themes/commit/f07f5da))
* **grid:** use toolbar styles for grid toolbar ([f429b96](https://github.com/telerik/kendo-themes/commit/f429b96))


### Features

* **bottom-navigation:** add styles for bottom navigation component ([5c97343](https://github.com/telerik/kendo-themes/commit/5c97343))
* **column-menu:** update spacings based on latest design ([b82f31c](https://github.com/telerik/kendo-themes/commit/b82f31c))
* **datetimepicker:** add milliseconds column in popup picker ([8f20baf](https://github.com/telerik/kendo-themes/commit/8f20baf))
* **tilelayout:** navigation shadow ([2aedeff](https://github.com/telerik/kendo-themes/commit/2aedeff))
* **utils:** add styles spacer utility classnames ([b0e3902](https://github.com/telerik/kendo-themes/commit/b0e3902))




<a name="4.25.0"></a>
# [4.25.0](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@4.24.0...@progress/kendo-theme-bootstrap@4.25.0) (2020-12-03)


### Bug Fixes

* ripple effect for checkboxes and radios ([7dfce23](https://github.com/telerik/kendo-themes/commit/7dfce23))
* **autocomplete:** remove redundant autocomplete variables ([5eebb0c](https://github.com/telerik/kendo-themes/commit/5eebb0c))
* rework input clear icon styles: ([8457bf7](https://github.com/telerik/kendo-themes/commit/8457bf7))


### Features

* **grid:** add focus shadow to the cells on native browser focus ([28290d9](https://github.com/telerik/kendo-themes/commit/28290d9))
* **grid:** col menu group header styles ([28ce0d4](https://github.com/telerik/kendo-themes/commit/28ce0d4))




<a name="4.24.0"></a>
# [4.24.0](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@4.23.2...@progress/kendo-theme-bootstrap@4.24.0) (2020-11-16)


### Bug Fixes

* **calendar:** adjust spacing ([575dbcd](https://github.com/telerik/kendo-themes/commit/575dbcd))
* **grid:** import float utility ([8e7aa96](https://github.com/telerik/kendo-themes/commit/8e7aa96))
* **loader:** use precise metrics that correspond to our sizing system ([6648a90](https://github.com/telerik/kendo-themes/commit/6648a90))
* **panelbar:** allow native :focus styles on items ([781c91c](https://github.com/telerik/kendo-themes/commit/781c91c))
* **typography:** streamline typography variables ([da6a879](https://github.com/telerik/kendo-themes/commit/da6a879))
* **window:** update window styles to match new font style metrics ([9c36541](https://github.com/telerik/kendo-themes/commit/9c36541))


### Features

* **fab:** add styles ([5d25359](https://github.com/telerik/kendo-themes/commit/5d25359))
* **loader-container:** add component styles ([987e603](https://github.com/telerik/kendo-themes/commit/987e603))
* **notification:** add styling based on theme colors ([ad97348](https://github.com/telerik/kendo-themes/commit/ad97348)), closes [telerik/kendo-themes#1981](https://github.com/telerik/kendo-themes/issues/1981)




<a name="4.23.2"></a>
## [4.23.2](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@4.23.1...@progress/kendo-theme-bootstrap@4.23.2) (2020-11-05)


### Bug Fixes

* **adaptive:** require toolbar styles explictly ([326945d](https://github.com/telerik/kendo-themes/commit/326945d))
* **chat:** require toolbar styles explictly ([0a96c6e](https://github.com/telerik/kendo-themes/commit/0a96c6e))
* **checkbox:** do not base checkbox variables on input variables ([d172930](https://github.com/telerik/kendo-themes/commit/d172930))
* **colorpicker:** require utils/flex styles explictly ([3d00ce4](https://github.com/telerik/kendo-themes/commit/3d00ce4))
* **dataviz:** require tooltip styles explicitly ([e308203](https://github.com/telerik/kendo-themes/commit/e308203))
* **dropdowngrid:** require toolbar variables explicitly ([5bb3eff](https://github.com/telerik/kendo-themes/commit/5bb3eff))
* **editor:** require toolbar styles before upload styles ([676ca40](https://github.com/telerik/kendo-themes/commit/676ca40))
* **file-manager:** require toolbar styles before upload styles ([71b328e](https://github.com/telerik/kendo-themes/commit/71b328e))
* **floating-label:** font-size and height based on input-font-size ([0c61a43](https://github.com/telerik/kendo-themes/commit/0c61a43))
* **floating-label:** require input variables explicitly ([8231f94](https://github.com/telerik/kendo-themes/commit/8231f94))
* **forms:** require common styles explicitly ([e9a5314](https://github.com/telerik/kendo-themes/commit/e9a5314))
* **input:** require button variables explictly ([069aeed](https://github.com/telerik/kendo-themes/commit/069aeed))
* **menu:** require popup styles explicitly ([c6b110a](https://github.com/telerik/kendo-themes/commit/c6b110a))
* **pager:** require toolbar variables explicitly ([61253bb](https://github.com/telerik/kendo-themes/commit/61253bb))
* **popoup:** require button styles explicitly ([dbea54c](https://github.com/telerik/kendo-themes/commit/dbea54c))
* **popup:** require input styles explicitly ([514d0c7](https://github.com/telerik/kendo-themes/commit/514d0c7))
* **splitter:** do not base splitbar variables on button variables ([aac856b](https://github.com/telerik/kendo-themes/commit/aac856b))
* **spreadsheet:** require toolbar styles before upload styles ([15833ff](https://github.com/telerik/kendo-themes/commit/15833ff))
* **switch:** do not depend on $button- variables ([073681f](https://github.com/telerik/kendo-themes/commit/073681f))
* **textbox:** base variables on input variables ([6522a00](https://github.com/telerik/kendo-themes/commit/6522a00))
* **treeview:** do not base treeview variables on button variables ([3005f6d](https://github.com/telerik/kendo-themes/commit/3005f6d))
* **upload:** require toolbar variables explicitly ([99b4319](https://github.com/telerik/kendo-themes/commit/99b4319))
* **utils:** require typography variables explicitly ([9ff3176](https://github.com/telerik/kendo-themes/commit/9ff3176))




<a name="4.23.1"></a>
## 4.23.1 (2020-11-02)




**Note:** Version bump only for package @progress/kendo-theme-bootstrap

<a name="4.23.0"></a>
# [4.23.0](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@4.22.0...@progress/kendo-theme-bootstrap@4.23.0) (2020-10-20)


### Bug Fixes

* **checkbox:** kendo-theme-bootstrap checkboxes should be consistent with bootstrap checkboxes ([bca8369](https://github.com/telerik/kendo-themes/commit/bca8369)), closes [telerik/kendo-ui-core#5719](https://github.com/telerik/kendo-ui-core/issues/5719)
* **checkbox:** use calc to calculate checkbox dash width ([0fe5d5b](https://github.com/telerik/kendo-themes/commit/0fe5d5b))
* **radio:** kendo-theme-bootstrap radios should be consistent with bootstrap radios ([71c0c0f](https://github.com/telerik/kendo-themes/commit/71c0c0f)), closes [telerik/kendo-ui-core#5719](https://github.com/telerik/kendo-ui-core/issues/5719)


### Features

* **avatar:** sizes, shapes and colors to avatar ([4010ff8](https://github.com/telerik/kendo-themes/commit/4010ff8))




<a name="4.22.0"></a>
# 4.22.0 (2020-10-13)


### Bug Fixes

* **actions:** extract actions variables into separate files ([ad38523](https://github.com/telerik/kendo-themes/commit/ad38523))
* **adaptive:** extract adaptive components variables into separate files ([1ff59ab](https://github.com/telerik/kendo-themes/commit/1ff59ab))
* **button:** extract button variables ([44a3806](https://github.com/telerik/kendo-themes/commit/44a3806))
* **card:** extract card variables into separate files ([d5bb957](https://github.com/telerik/kendo-themes/commit/d5bb957))
* **form:** extract form variables into separate files ([605019e](https://github.com/telerik/kendo-themes/commit/605019e))
* **grid:** restyle the grid footer ([68f048f](https://github.com/telerik/kendo-themes/commit/68f048f))
* **grid:** validation popup position in Material theme ([c01b44e](https://github.com/telerik/kendo-themes/commit/c01b44e))
* **input:** extract input variables into separate files ([c1889b5](https://github.com/telerik/kendo-themes/commit/c1889b5))
* **menu:** extract menu variables into separate files ([96f8021](https://github.com/telerik/kendo-themes/commit/96f8021))
* **notification:** declare poup as explicit dependency ([b19a8ff](https://github.com/telerik/kendo-themes/commit/b19a8ff))
* **pager:** extract pager variables into separate files ([de4707c](https://github.com/telerik/kendo-themes/commit/de4707c))
* **panelbar:** extract panelbar variables into separate files ([9b47ece](https://github.com/telerik/kendo-themes/commit/9b47ece))
* **popup:** extract popup variables ([94dc5f9](https://github.com/telerik/kendo-themes/commit/94dc5f9))
* **progressbar:** center progress label inside progressbar ([6402819](https://github.com/telerik/kendo-themes/commit/6402819)), closes [telerik/kendo-themes#1945](https://github.com/telerik/kendo-themes/issues/1945) [telerik/kendo-themes#1947](https://github.com/telerik/kendo-themes/issues/1947)
* **progressbar:** extract progressbar variables into separate files ([000040f](https://github.com/telerik/kendo-themes/commit/000040f))
* **scheduler:** extract scheduler variables into separate files ([26c9c9a](https://github.com/telerik/kendo-themes/commit/26c9c9a))
* **scheduler:** use uniform values for shceduler nonwork and othermonth cells ([3eaa95b](https://github.com/telerik/kendo-themes/commit/3eaa95b))
* **toolbar:** extract toolbar variables ([5126f1d](https://github.com/telerik/kendo-themes/commit/5126f1d))
* **typography:** extract typography variables into separate files ([5315fa4](https://github.com/telerik/kendo-themes/commit/5315fa4))
* **window:** extract window variables ([2011e06](https://github.com/telerik/kendo-themes/commit/2011e06))


### Features

* **grid:** add sticky rows styling ([f02e23c](https://github.com/telerik/kendo-themes/commit/f02e23c))
* add styles for searchbox component ([a25097e](https://github.com/telerik/kendo-themes/commit/a25097e))




<a name="4.21.1"></a>
## [4.21.1](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@4.21.0...@progress/kendo-theme-bootstrap@4.21.1) (2020-09-15)


### Bug Fixes

* **grid:** add styles for column menu focus items ([#1796](https://github.com/telerik/kendo-themes/issues/1796)) ([8faa5d4](https://github.com/telerik/kendo-themes/commit/8faa5d4))




<a name="4.21.0"></a>
# [4.21.0](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@4.20.0...@progress/kendo-theme-bootstrap@4.21.0) (2020-09-14)


### Bug Fixes

* set top margin to the form hint ([f8843cf](https://github.com/telerik/kendo-themes/commit/f8843cf))
* **gantt:** adjust planned vs actual styles telerik/kendo[#11149](https://github.com/telerik/kendo-themes/issues/11149) ([a055c1a](https://github.com/telerik/kendo-themes/commit/a055c1a))
* change default bootstrap border color depending on document background ([579c485](https://github.com/telerik/kendo-themes/commit/579c485))
* remove soldomly used header-hover and header-selected variables ([9fb414f](https://github.com/telerik/kendo-themes/commit/9fb414f))
* update colors in bootstrap theme to match v4.5 ([78b1e4f](https://github.com/telerik/kendo-themes/commit/78b1e4f))
* **card:** update card colors to match bootstrap 4.5.1 ([#787](https://github.com/telerik/kendo-themes/issues/787)) ([9b341ca](https://github.com/telerik/kendo-themes/commit/9b341ca))
* **dropdown:** update dropdown colors to match bootstrap 4.5.1 ([#787](https://github.com/telerik/kendo-themes/issues/787)) ([1ed5e47](https://github.com/telerik/kendo-themes/commit/1ed5e47))
* **gantt:** make delete over offset always visible telerik/kendo[#11149](https://github.com/telerik/kendo-themes/issues/11149) ([f89970c](https://github.com/telerik/kendo-themes/commit/f89970c))
* **input:** update input border and text color to match bootstrap 4.5.1 ([9a23b87](https://github.com/telerik/kendo-themes/commit/9a23b87))
* **listgroup:** kendo-listgroup styles did not override bootstrap-listgroup styles correctly ([d78f491](https://github.com/telerik/kendo-themes/commit/d78f491))
* **radio:** invalid radio styles are missing in kendo-jquery ([#1122](https://github.com/telerik/kendo-themes/issues/1122)) ([24d74eb](https://github.com/telerik/kendo-themes/commit/24d74eb))


### Features

* add dark bootstrap-3 based swatch ([f848f93](https://github.com/telerik/kendo-themes/commit/f848f93))




<a name="4.20.0"></a>
# 4.20.0 (2020-09-08)


### Bug Fixes

* **card:** generate styles for theme colors ([c7f6e3f](https://github.com/telerik/kendo-themes/commit/c7f6e3f))
* **card:** improve card callout styles ([cc1f20b](https://github.com/telerik/kendo-themes/commit/cc1f20b))
* **card:** refactor card actions to behave as expected ([6421f0d](https://github.com/telerik/kendo-themes/commit/6421f0d))
* **form:** remove unused bottom margin in bootstrap theme ([19aebff](https://github.com/telerik/kendo-themes/commit/19aebff))
* **input:** extract input styles as a separate module ([c67e163](https://github.com/telerik/kendo-themes/commit/c67e163))
* **toolbar:** make toolbar container for buttons ([cee0b45](https://github.com/telerik/kendo-themes/commit/cee0b45))


### Features

* **editor:** add find and replace dialog styles ([4676a4d](https://github.com/telerik/kendo-themes/commit/4676a4d))
* **gantt:** add styles for gantt with treelist rendering ([e9e9c9d](https://github.com/telerik/kendo-themes/commit/e9e9c9d))
* **gantt:** add styles for Planned vs Actual telerik/kendo[#11149](https://github.com/telerik/kendo-themes/issues/11149) ([23a1ffa](https://github.com/telerik/kendo-themes/commit/23a1ffa))
* **imageeditor:** add component styles ([00762f8](https://github.com/telerik/kendo-themes/commit/00762f8)), closes [#1801](https://github.com/telerik/kendo-themes/issues/1801)
* **utils:** overflow classes ([025cdb5](https://github.com/telerik/kendo-themes/commit/025cdb5))




<a name="4.19.0"></a>
# 4.19.0 (2020-08-06)


### Bug Fixes

* **grid:** update locked columns styling ([b62d304](https://github.com/telerik/kendo-themes/commit/b62d304))
* add missing px units to 0 variables ([c6684bf](https://github.com/telerik/kendo-themes/commit/c6684bf))
* always pass value to border-*-radius mixins ([efffbe8](https://github.com/telerik/kendo-themes/commit/efffbe8))
* **cards:** update styles to match latest design ([da77702](https://github.com/telerik/kendo-themes/commit/da77702))
* **common:** expose utils into separate module ([1946a85](https://github.com/telerik/kendo-themes/commit/1946a85))


### Features

* **button:** add clear button styling ([a87a61e](https://github.com/telerik/kendo-themes/commit/a87a61e))
* add TextArea styles ([cffdde6](https://github.com/telerik/kendo-themes/commit/cffdde6))
* **badge:** rework badge styles to use stacked styles ([04c279f](https://github.com/telerik/kendo-themes/commit/04c279f))
* provide styling for action buttons ([d852003](https://github.com/telerik/kendo-themes/commit/d852003))




<a name="4.18.0"></a>
# 4.18.0 (2020-07-22)


### Bug Fixes

* **action-buttons:** unify action buttons appearance ([9020c4e](https://github.com/telerik/kendo-themes/commit/9020c4e))
* **treelist:** update treelist footer row styling ([eca6d82](https://github.com/telerik/kendo-themes/commit/eca6d82))


### Features

* **editor:** add placeholder styles ([949806d](https://github.com/telerik/kendo-themes/commit/949806d))




<a name="4.17.0"></a>
# [4.17.0](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@4.16.2...@progress/kendo-theme-bootstrap@4.17.0) (2020-06-09)


### Bug Fixes

* add !optional flag to k-text-selection ([72f3c4d](https://github.com/telerik/kendo-themes/commit/72f3c4d))
* **avatar:** remove margin ([d84f6cd](https://github.com/telerik/kendo-themes/commit/d84f6cd))
* **gantt:** use correct variables for base gantt styling ([fe0938b](https://github.com/telerik/kendo-themes/commit/fe0938b))
* **pdf-viewer:** add missing variables for bg, text and border ([19ec383](https://github.com/telerik/kendo-themes/commit/19ec383))
* **upload:** add max-height and scroll ([815f766](https://github.com/telerik/kendo-themes/commit/815f766))
* **wizard:** update step focus state ([27094c9](https://github.com/telerik/kendo-themes/commit/27094c9))


### Features

* **wizard:** add styling and tests for Wizard component ([c66958d](https://github.com/telerik/kendo-themes/commit/c66958d))




<a name="4.16.2"></a>
## [4.16.2](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@4.16.1...@progress/kendo-theme-bootstrap@4.16.2) (2020-05-20)


### Bug Fixes

* **drawer:** focused and selected style in bootstrap and material telerik/kendo-themes/issues/1550 ([afbe808](https://github.com/telerik/kendo-themes/commit/afbe808))
* **multiselect:** button height adjustment ([ab40bd2](https://github.com/telerik/kendo-themes/commit/ab40bd2))




<a name="4.16.1"></a>
## [4.16.1](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@4.16.0...@progress/kendo-theme-bootstrap@4.16.1) (2020-05-11)


### Bug Fixes

* **forms:** place optional label below label in horizontal forms ([5fbc252](https://github.com/telerik/kendo-themes/commit/5fbc252))
* **stepper:** update steps hover styling ([9119340](https://github.com/telerik/kendo-themes/commit/9119340))




<a name="4.16.0"></a>
# 4.16.0 (2020-05-08)


### Bug Fixes

* **forms:** various fixes and adjustments ([24b96bc](https://github.com/telerik/kendo-themes/commit/24b96bc))
* **listview:** add styles for various listview settings ([6b218a5](https://github.com/telerik/kendo-themes/commit/6b218a5))
* **messagebox:** add link style ([2b00a57](https://github.com/telerik/kendo-themes/commit/2b00a57))
* **scheduler:** use toolbar styles for scheduler toolbar ([6b7a40f](https://github.com/telerik/kendo-themes/commit/6b7a40f))
* **stepper:** add color contrast for progressbar/border future steps ([223effd](https://github.com/telerik/kendo-themes/commit/223effd))
* **upload:** update colors to match the new design ([3375e05](https://github.com/telerik/kendo-themes/commit/3375e05))


### Features

* **dropzone:** add external dropzone styling and tests ([0879f80](https://github.com/telerik/kendo-themes/commit/0879f80))
* **tilelayout:** add styles ([82ccd6a](https://github.com/telerik/kendo-themes/commit/82ccd6a))
* **treeview:** add styles for tree view load more functionality ([d4576c4](https://github.com/telerik/kendo-themes/commit/d4576c4))
* **upload:** update styling to match the design ([553a69e](https://github.com/telerik/kendo-themes/commit/553a69e))




<a name="4.15.0"></a>
# [4.15.0](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@4.14.0...@progress/kendo-theme-bootstrap@4.15.0) (2020-04-09)


### Bug Fixes

* **forms:** various fixes and improvements ([b847a02](https://github.com/telerik/kendo-themes/commit/b847a02))
* **inputs:** invalid+focus states for inputs, maskedtextbox and numerictextbox ([6e7e507](https://github.com/telerik/kendo-themes/commit/6e7e507))
* unify error statesfor input components ([8e9b2de](https://github.com/telerik/kendo-themes/commit/8e9b2de))


### Features

* add Cursor styles ([24bcdce](https://github.com/telerik/kendo-themes/commit/24bcdce))
* **forms:** implement forms styling ([0fc957c](https://github.com/telerik/kendo-themes/commit/0fc957c))
* **stepper:** add stepper styles ([359c37c](https://github.com/telerik/kendo-themes/commit/359c37c))




<a name="4.14.0"></a>
# [4.14.0](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@4.13.0...@progress/kendo-theme-bootstrap@4.14.0) (2020-04-02)


### Bug Fixes

* **filemanager:** use sizing system to set spacing in filemanager ([57a7244](https://github.com/telerik/kendo-themes/commit/57a7244))
* **grid:** remove frozen columns hover row background opacity ([4026df5](https://github.com/telerik/kendo-themes/commit/4026df5))
* **pager:** update pager numbers focus/selected states ([f38081e](https://github.com/telerik/kendo-themes/commit/f38081e))
* introduce map with predefined spacing values ([235530c](https://github.com/telerik/kendo-themes/commit/235530c))


### Features

* add styles for flex and grid layout ([1c63d50](https://github.com/telerik/kendo-themes/commit/1c63d50))
* add styles for message box ([c10d31c](https://github.com/telerik/kendo-themes/commit/c10d31c))




<a name="4.13.0"></a>
# [4.13.0](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@4.12.0...@progress/kendo-theme-bootstrap@4.13.0) (2020-03-30)


### Features

* **listview:** allow listview content to have grid or flex layout ([09a9d52](https://github.com/telerik/kendo-themes/commit/09a9d52))
* **pager:** add styling for standalone pager component ([f7cecc8](https://github.com/telerik/kendo-themes/commit/f7cecc8))




<a name="4.12.0"></a>
# [4.12.0](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@4.11.0...@progress/kendo-theme-bootstrap@4.12.0) (2020-03-17)


### Bug Fixes

* **colorpicker:** boot and mat inherit default ([b86a098](https://github.com/telerik/kendo-themes/commit/b86a098))
* **colorpicker:** use fill mixin ([0ee0837](https://github.com/telerik/kendo-themes/commit/0ee0837))
* **dataviz:** use fill mixin ([06e4d09](https://github.com/telerik/kendo-themes/commit/06e4d09))
* **datetime:** use fill mixin ([d521d7a](https://github.com/telerik/kendo-themes/commit/d521d7a))
* **notification:** use fill mixin ([80e6d9b](https://github.com/telerik/kendo-themes/commit/80e6d9b))
* **popup:** disabled items in popup appearance ([3818a7b](https://github.com/telerik/kendo-themes/commit/3818a7b))
* **toolbar:** use fill mixin ([fa17fac](https://github.com/telerik/kendo-themes/commit/fa17fac))


### Features

* **badge:** add support for icons in badges ([77f2617](https://github.com/telerik/kendo-themes/commit/77f2617))




<a name="4.11.0"></a>
# 4.11.0 (2020-03-06)


### Bug Fixes

* **badge:** conditionally set badge size to fixed or calculated ([39a7128](https://github.com/telerik/kendo-themes/commit/39a7128))
* **badge:** use only translate styles for badge position ([ea051dc](https://github.com/telerik/kendo-themes/commit/ea051dc))
* **gantt:** use fill mixin ([1072826](https://github.com/telerik/kendo-themes/commit/1072826))
* **grid:** use fill mixin ([937e52c](https://github.com/telerik/kendo-themes/commit/937e52c))
* **listbox:** use fill mixin ([61e53c3](https://github.com/telerik/kendo-themes/commit/61e53c3))
* **pivotgrid:** use fill mixin ([ae9276a](https://github.com/telerik/kendo-themes/commit/ae9276a))
* **popup:** use fill mixin ([02a73a0](https://github.com/telerik/kendo-themes/commit/02a73a0))
* **scheduler:** use fill mixin ([4d9926c](https://github.com/telerik/kendo-themes/commit/4d9926c))
* **spreadsheet:** use fill mixin ([8c396b2](https://github.com/telerik/kendo-themes/commit/8c396b2))


### Features

* **badge:** add badge sizes ([c0a983b](https://github.com/telerik/kendo-themes/commit/c0a983b))
* **badge:** add circle and dot shape for badge ([6c3ef98](https://github.com/telerik/kendo-themes/commit/6c3ef98))
* **badge:** add styles for tertiary, dark, light and iverse badges ([82ad426](https://github.com/telerik/kendo-themes/commit/82ad426))
* **color-system:** add tertiary, dark, light and inverse colors ([513b5ed](https://github.com/telerik/kendo-themes/commit/513b5ed))
* **inputs:** add focused box-shadow in bootstrap ([feb7055](https://github.com/telerik/kendo-themes/commit/feb7055))
* **pager:** use native select for responsive pager page selection ([59cf508](https://github.com/telerik/kendo-themes/commit/59cf508))
* **styles:** allow adaptive rendering without height ([aa2afa3](https://github.com/telerik/kendo-themes/commit/aa2afa3))
* **upload:** update styles to fit updated design ([0f47d17](https://github.com/telerik/kendo-themes/commit/0f47d17))




<a name="4.10.2"></a>
## 4.10.2 (2020-02-14)


### Bug Fixes

* **badge:** extract badge-border-radius variable ([d646feb](https://github.com/telerik/kendo-themes/commit/d646feb))
* **breadcrumb:** extract breadcrumb-link-border-radius variable ([ab90929](https://github.com/telerik/kendo-themes/commit/ab90929))
* **drawer:** fix flickering upon mini mode collapsing ([3ba8d87](https://github.com/telerik/kendo-themes/commit/3ba8d87))
* **editor:** make jQuery editor toolbar look like regular toolbar ([bfd016c](https://github.com/telerik/kendo-themes/commit/bfd016c))
* **gantt:** dependency lines are not displayed in rtl ([c0b3355](https://github.com/telerik/kendo-themes/commit/c0b3355))
* **grid:** inconsistent grouping header height ([b7ea9be](https://github.com/telerik/kendo-themes/commit/b7ea9be))
* **notification:** extract notification variables ([4ec43f2](https://github.com/telerik/kendo-themes/commit/4ec43f2))
* **textarea:** extract scss variable ([fdd4186](https://github.com/telerik/kendo-themes/commit/fdd4186))
* **toolbar:** remove right border from popup menu button in RTL mode ([c106c9a](https://github.com/telerik/kendo-themes/commit/c106c9a))
* switch usages of button-*-size functions with button-calc-* vars ([6437547](https://github.com/telerik/kendo-themes/commit/6437547))




<a name="4.10.1"></a>
## [4.10.1](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@4.10.0...@progress/kendo-theme-bootstrap@4.10.1) (2020-02-04)


### Bug Fixes

* **menu:** expose menu variables for customization ([d18a1a6](https://github.com/telerik/kendo-themes/commit/d18a1a6))
* remove circular dependecies between components ([a7334cf](https://github.com/telerik/kendo-themes/commit/a7334cf))
* **color-system:** move color level and yiq variables in color functions ([f32259a](https://github.com/telerik/kendo-themes/commit/f32259a))
* **dropdowngrid:** remove Grid style dependencies ([4fbb721](https://github.com/telerik/kendo-themes/commit/4fbb721))
* **map:** extract and use map variables ([a5fffde](https://github.com/telerik/kendo-themes/commit/a5fffde))
* **slider:** background-image empty url in material theme ([96fd3fa](https://github.com/telerik/kendo-themes/commit/96fd3fa))
* **tabstrip:** add variables for item gradient ([8e3c46b](https://github.com/telerik/kendo-themes/commit/8e3c46b))
* Chat message-box theme ([ac4cccc](https://github.com/telerik/kendo-themes/commit/ac4cccc))
* Default variables leakage to other themes ([df48dae](https://github.com/telerik/kendo-themes/commit/df48dae))
* **slider:** use correct values for slider background ([5c0fb9a](https://github.com/telerik/kendo-themes/commit/5c0fb9a))




<a name="4.10.0"></a>
# [4.10.0](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@4.9.1...@progress/kendo-theme-bootstrap@4.10.0) (2020-01-23)


### Bug Fixes

* **color-system:** use  instead of ([7e973f3](https://github.com/telerik/kendo-themes/commit/7e973f3))
* **color-system:** use contrast-wcag function instead of explicit contrst colors ([ced09de](https://github.com/telerik/kendo-themes/commit/ced09de))
* **color-system:** use correct grading of color level function ([950d639](https://github.com/telerik/kendo-themes/commit/950d639))
* introduce and use component variables ([8f1951f](https://github.com/telerik/kendo-themes/commit/8f1951f))
* move api generation to theme-tasks ([c754811](https://github.com/telerik/kendo-themes/commit/c754811))


### Features

* **color-system:** introduce lighter and darker shades of theme colors ([7a1c2a3](https://github.com/telerik/kendo-themes/commit/7a1c2a3))




<a name="4.9.1"></a>
## [4.9.1](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@4.9.0...@progress/kendo-theme-bootstrap@4.9.1) (2020-01-13)


### Bug Fixes

* flex scheduler row hover ([4d62c7a](https://github.com/telerik/kendo-themes/commit/4d62c7a))
* flex scheduler slot selection ([fee1171](https://github.com/telerik/kendo-themes/commit/fee1171))




<a name="4.9.0"></a>
# [4.9.0](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@4.8.0...@progress/kendo-theme-bootstrap@4.9.0) (2020-01-09)


### Bug Fixes

* add checkbox / radio styles for IE 11 / Edge ([d4680c4](https://github.com/telerik/kendo-themes/commit/d4680c4))
* **drawer:** switch drawer item text padding in rtl mode ([ca2fe37](https://github.com/telerik/kendo-themes/commit/ca2fe37))


### Features

* **chip:** add component styles ([a184d92](https://github.com/telerik/kendo-themes/commit/a184d92))
* **filemanager:** add component styles ([37ec1d5](https://github.com/telerik/kendo-themes/commit/37ec1d5)), closes [telerik/kendo#10436](https://github.com/telerik/kendo/issues/10436)
* **upload:** integrate file group icons ([9e2a76e](https://github.com/telerik/kendo-themes/commit/9e2a76e)), closes [telerik/kendo#10422](https://github.com/telerik/kendo/issues/10422)




<a name="4.8.0"></a>
# [4.8.0](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@4.7.0...@progress/kendo-theme-bootstrap@4.8.0) (2019-12-17)


### Bug Fixes

* **card:** avatar and card elements display improvements ([3e69ae1](https://github.com/telerik/kendo-themes/commit/3e69ae1))
* **colorpicker:** flatcolorpicker misaligned in rtl ([8ce3ee4](https://github.com/telerik/kendo-themes/commit/8ce3ee4)), closes [telerik/kendo-ui-core#5420](https://github.com/telerik/kendo-ui-core/issues/5420)
* **contextmenu:** inconsistent styles ([3a657ff](https://github.com/telerik/kendo-themes/commit/3a657ff))
* **multiselect:** wrong width value ([0c822f1](https://github.com/telerik/kendo-themes/commit/0c822f1))


### Features

* **placeholder:** add placeholder line styles ([7cd1bd2](https://github.com/telerik/kendo-themes/commit/7cd1bd2))




<a name="4.7.0"></a>
# [4.7.0](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@4.6.0...@progress/kendo-theme-bootstrap@4.7.0) (2019-12-04)


### Bug Fixes

* **tabstrip:** tab selected styles based on orientation in nested tabstrips ([e0d5ef4](https://github.com/telerik/kendo-themes/commit/e0d5ef4))


### Features

* **avatar:** add shape styles ([c140647](https://github.com/telerik/kendo-themes/commit/c140647))




<a name="4.6.0"></a>
# [4.6.0](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@4.5.0...@progress/kendo-theme-bootstrap@4.6.0) (2019-11-29)


### Bug Fixes

* remove explicit width for checkbox label ([7efdbd4](https://github.com/telerik/kendo-themes/commit/7efdbd4))
* **grid:** add styles for selected column menu item ([30421de](https://github.com/telerik/kendo-themes/commit/30421de))


### Features

* add listgroup styles ([7eaea1d](https://github.com/telerik/kendo-themes/commit/7eaea1d))
* **avatar:** add component styles ([ad0d07b](https://github.com/telerik/kendo-themes/commit/ad0d07b))
* **badge:** component styles ([367f6a4](https://github.com/telerik/kendo-themes/commit/367f6a4))




<a name="4.5.0"></a>
# 4.5.0 (2019-11-21)


### Bug Fixes

* **colorpicker:** add numerictextbox as a dependency to colorpicker ([899fbd5](https://github.com/telerik/kendo-themes/commit/899fbd5))
* **grid:** add locked column selected, hovered and selected hovered states variables ([fa99539](https://github.com/telerik/kendo-themes/commit/fa99539))
* **grid:** locked column hovered and selected hovered state background ([89ee7a0](https://github.com/telerik/kendo-themes/commit/89ee7a0))
* **grid:** selected locked columns contenthave background with opacity ([c82419f](https://github.com/telerik/kendo-themes/commit/c82419f))
* **grid:** sorted locked column header does not have background color ([1d16df6](https://github.com/telerik/kendo-themes/commit/1d16df6))
* **multiselect:** extract scss variables ([8ddbc6b](https://github.com/telerik/kendo-themes/commit/8ddbc6b))
* **numerictextbox:** extract scss variables ([1a6b0bc](https://github.com/telerik/kendo-themes/commit/1a6b0bc))
* add whitespace around operators in calc expressions ([02ee4b6](https://github.com/telerik/kendo-themes/commit/02ee4b6))


### Features

* **breadcrumb:** add styles for breadcrumb component ([400fd43](https://github.com/telerik/kendo-themes/commit/400fd43))
* **checkbox:** add invalid, indeterminate and long labels styles ([43ee6c8](https://github.com/telerik/kendo-themes/commit/43ee6c8))
* **radio:** style native radio through k-radio class ([f7d9906](https://github.com/telerik/kendo-themes/commit/f7d9906))




<a name="4.4.0"></a>
# [4.4.0](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@4.3.7...@progress/kendo-theme-bootstrap@4.4.0) (2019-10-25)


### Bug Fixes

* **autocomplete:** extract scss variables ([3800a14](https://github.com/telerik/kendo-themes/commit/3800a14))
* **grid:** edit selector for locked columns to be applied in both grid and treelist ([e3fc434](https://github.com/telerik/kendo-themes/commit/e3fc434))


### Features

* allow default theme reuse without background-clip ([58abbf5](https://github.com/telerik/kendo-themes/commit/58abbf5)), closes [#512](https://github.com/telerik/kendo-themes/issues/512)




<a name="4.3.7"></a>
## [4.3.7](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@4.3.6...@progress/kendo-theme-bootstrap@4.3.7) (2019-10-22)




**Note:** Version bump only for package @progress/kendo-theme-bootstrap

<a name="4.3.6"></a>
## [4.3.6](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@4.3.5...@progress/kendo-theme-bootstrap@4.3.6) (2019-10-22)


### Bug Fixes

* **radio-checkbox:** update radio / checkbox appearance in bootstrap theme ([89cf2bd](https://github.com/telerik/kendo-themes/commit/89cf2bd))




<a name="4.3.5"></a>
## 4.3.5 (2019-10-21)


### Bug Fixes

* split functions and variables into separate import files ([cda7960](https://github.com/telerik/kendo-themes/commit/cda7960))
* **colorpicker:** extract scss variables ([493b5a1](https://github.com/telerik/kendo-themes/commit/493b5a1))
* **datetime:** invalid state style in grid-editing ([8d8d45c](https://github.com/telerik/kendo-themes/commit/8d8d45c))
* **dropdownlist:** fix popup content overflowing when filtering is enabled [#920](https://github.com/telerik/kendo-themes/issues/920) ([2258964](https://github.com/telerik/kendo-themes/commit/2258964))
* **input:** extract variable for input floating label background ([e05ddac](https://github.com/telerik/kendo-themes/commit/e05ddac))
* **input:** extract variables for floating labels focused state ([146937f](https://github.com/telerik/kendo-themes/commit/146937f))
* **upload:** extract variables for upload component ([1f1c517](https://github.com/telerik/kendo-themes/commit/1f1c517))




<a name="4.3.4"></a>
## [4.3.4](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@4.3.3...@progress/kendo-theme-bootstrap@4.3.4) (2019-10-11)


### Bug Fixes

* handle api-check, ci and prepubilsh tasks from gulp ([71175b2](https://github.com/telerik/kendo-themes/commit/71175b2))
* **colorpicker:** input cut off in bootstrap theme ([91bd81a](https://github.com/telerik/kendo-themes/commit/91bd81a))
* **menu:** submenu double padding in blazor bootstrap theme ([0f3d022](https://github.com/telerik/kendo-themes/commit/0f3d022))
* **slider:** rtl styles ([5260318](https://github.com/telerik/kendo-themes/commit/5260318))




<a name="4.3.3"></a>
## [4.3.3](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@4.3.2...@progress/kendo-theme-bootstrap@4.3.3) (2019-09-27)




**Note:** Version bump only for package @progress/kendo-theme-bootstrap

<a name="4.3.2"></a>
## [4.3.2](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@4.3.1...@progress/kendo-theme-bootstrap@4.3.2) (2019-09-17)


### Bug Fixes

* **window:** remove explicit background and color from window titlebar in bootstrap theme ([3de8414](https://github.com/telerik/kendo-themes/commit/3de8414))
* **window:** wrong height of window titlebar in bootstrap theme ([bce63f5](https://github.com/telerik/kendo-themes/commit/bce63f5))




<a name="4.3.1"></a>
## [4.3.1](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@4.3.0...@progress/kendo-theme-bootstrap@4.3.1) (2019-09-17)




**Note:** Version bump only for package @progress/kendo-theme-bootstrap

<a name="4.3.0"></a>
# [4.3.0](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@4.2.0...@progress/kendo-theme-bootstrap@4.3.0) (2019-09-16)


### Bug Fixes

* **buttongroup:** remove double border from .k-widget.k-button-group ([47bcd7e](https://github.com/telerik/kendo-themes/commit/47bcd7e))
* **calendar:** adjust calendar width for blazor suite ([9e28dfb](https://github.com/telerik/kendo-themes/commit/9e28dfb))
* **filter:** update width of filter operator and grouping elements ([76f2e2f](https://github.com/telerik/kendo-themes/commit/76f2e2f))
* **grid:** add styles for locked columns feature ([64cc404](https://github.com/telerik/kendo-themes/commit/64cc404))


### Features

* **calendar:** add styles for blazor calendar ([a3db613](https://github.com/telerik/kendo-themes/commit/a3db613))




<a name="4.2.0"></a>
# [4.2.0](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@4.1.0...@progress/kendo-theme-bootstrap@4.2.0) (2019-09-02)


### Bug Fixes

* **card:** update subtitle color to match design ([dbea6f6](https://github.com/telerik/kendo-themes/commit/dbea6f6))


### Features

* **card:** add callout and update styles based on the design ([bf3bc1c](https://github.com/telerik/kendo-themes/commit/bf3bc1c))
* **filter:** widget styles ([2334e35](https://github.com/telerik/kendo-themes/commit/2334e35))
* **pdf-viewer:** add search dialog styles ([4e4742e](https://github.com/telerik/kendo-themes/commit/4e4742e))
* **pdf-viewer:** add text layer sass styles ([bcf3a3a](https://github.com/telerik/kendo-themes/commit/bcf3a3a))
* **timeline:** widget styles ([dbee03c](https://github.com/telerik/kendo-themes/commit/dbee03c))




<a name="4.1.0"></a>
# [4.1.0](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@4.0.0...@progress/kendo-theme-bootstrap@4.1.0) (2019-07-26)


### Features

* rating styles ([1104050](https://github.com/telerik/kendo-themes/commit/1104050))




<a name="4.0.0"></a>
# [4.0.0](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@3.4.2...@progress/kendo-theme-bootstrap@4.0.0) (2019-07-08)


### Bug Fixes

* add !default flag to more variables ([5372039](https://github.com/telerik/kendo-themes/commit/5372039))
* **multiselect:** placeholder color ([aba2611](https://github.com/telerik/kendo-themes/commit/aba2611))
* remove usages of add-two and add-three ([604a730](https://github.com/telerik/kendo-themes/commit/604a730))


### Features

* fit frozen group header text in one row ([17382fe](https://github.com/telerik/kendo-themes/commit/17382fe))
* modify themes for dart-sass ([d3e1c27](https://github.com/telerik/kendo-themes/commit/d3e1c27))
* **grid:** add styles for search bar within grid toolbar ([0460702](https://github.com/telerik/kendo-themes/commit/0460702))


### BREAKING CHANGES

* remove add-two and add-three functions due to dart-sass compatibility issues
* Refactor themes so they can be compiled with dart-sass:

* create `.k-button-flat` selector for `@extend` use
* create `.k-button-overlay` selector for `@extend` use
* replace `@extend` usages of composite selectors `.k-button.k-flat` and `.k-button::before` with said selectors




<a name="3.4.2"></a>
## 3.4.2 (2019-06-12)


### Bug Fixes

* use gulp tasks in themes instead of lerna ([f5d5c0c](https://github.com/telerik/kendo-themes/commit/f5d5c0c))
* **drawer:** fix includes in bootstrap theme ([ed4364d](https://github.com/telerik/kendo-themes/commit/ed4364d))
* **grid:** adaptive renedering checkbox focused state ([12c2dbe](https://github.com/telerik/kendo-themes/commit/12c2dbe))
* **grid:** add no records template styles ([0c64ab0](https://github.com/telerik/kendo-themes/commit/0c64ab0))
* **notification:** improve alignment of text and icons in notification ([e629688](https://github.com/telerik/kendo-themes/commit/e629688))




<a name="3.4.1"></a>
## [3.4.1](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@3.4.0...@progress/kendo-theme-bootstrap@3.4.1) (2019-05-15)




**Note:** Version bump only for package @progress/kendo-theme-bootstrap

<a name="3.4.0"></a>
# 3.4.0 (2019-05-13)


### Bug Fixes

* **colorpicker:** alpha slider bgr using embed assets script ([a300c78](https://github.com/telerik/kendo-themes/commit/a300c78))
* drawer overlay closed layout ([9b09fa1](https://github.com/telerik/kendo-themes/commit/9b09fa1))
* **colorpicker:** bootstrap and material themes icon hover styles ([d451132](https://github.com/telerik/kendo-themes/commit/d451132))
* **colorpicker:** flex layout glitches when hiding dynamically content ([9711ef9](https://github.com/telerik/kendo-themes/commit/9711ef9))


### Features

* drawer styles ([76c7ea3](https://github.com/telerik/kendo-themes/commit/76c7ea3))
* **spreadsheet:** add images sass styles ([b369217](https://github.com/telerik/kendo-themes/commit/b369217))




<a name="3.3.1"></a>
## [3.3.1](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@3.3.0...@progress/kendo-theme-bootstrap@3.3.1) (2019-04-09)




**Note:** Version bump only for package @progress/kendo-theme-bootstrap

<a name="3.3.0"></a>
# [3.3.0](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@3.2.3...@progress/kendo-theme-bootstrap@3.3.0) (2019-04-08)


### Bug Fixes

* **buttons:** disabled focused buttons styles in mozilla ([961f592](https://github.com/telerik/kendo-themes/commit/961f592))
* **textbox:** placeholder color in IE ([cfd732a](https://github.com/telerik/kendo-themes/commit/cfd732a))


### Features

* **calendar:** add styles for Blazor calendar ([8987d65](https://github.com/telerik/kendo-themes/commit/8987d65))
* **pager:** rendering changes and styles ([0a5642b](https://github.com/telerik/kendo-themes/commit/0a5642b))




<a name="3.2.3"></a>
## 3.2.3 (2019-03-14)


### Bug Fixes

* upgrade theme dependency to bootstrap 4.3.1 ([eedd116](https://github.com/telerik/kendo-themes/commit/eedd116))
* **buttons:** use correct color for .k-button.k-flat:hover.k-state-active ([eebad66](https://github.com/telerik/kendo-themes/commit/eebad66))
* **colorpicker:** wrapper hover styles not applied ([0f5ea5e](https://github.com/telerik/kendo-themes/commit/0f5ea5e))
* **dropdowns:** remove list items transform transitions ([71f3982](https://github.com/telerik/kendo-themes/commit/71f3982))
* **grid:** added active styles for grid column menu ([dfd1bc6](https://github.com/telerik/kendo-themes/commit/dfd1bc6))
* **grid:** grouping header text overflows with frozen columns ([779a216](https://github.com/telerik/kendo-themes/commit/779a216))
* **scheduler:** decreasing bootstrap padding in angular ([8ad054c](https://github.com/telerik/kendo-themes/commit/8ad054c))
* **scheduler:** month view style improvements ([e3dc082](https://github.com/telerik/kendo-themes/commit/e3dc082))
* **toolbar:** added min-height ([452f4c0](https://github.com/telerik/kendo-themes/commit/452f4c0))




<a name="3.2.2"></a>
## [3.2.2](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@3.2.1...@progress/kendo-theme-bootstrap@3.2.2) (2019-02-19)


### Bug Fixes

* **gantt:** improve focused toolbar item styles ([1c2d77f](https://github.com/telerik/kendo-themes/commit/1c2d77f))
* **scheduler:** improve scheduler event styles ([a37e948](https://github.com/telerik/kendo-themes/commit/a37e948))




<a name="3.2.1"></a>
## 3.2.1 (2019-02-14)


### Bug Fixes

* **editor:** selected table cells styles ([3e9bc58](https://github.com/telerik/kendo-themes/commit/3e9bc58))
* **grid:** improve styles for column settings menu ([6f5ba27](https://github.com/telerik/kendo-themes/commit/6f5ba27))
* **input:** edge specific style for inputs in flex container ([2e80be3](https://github.com/telerik/kendo-themes/commit/2e80be3))
* **pivotgrid:** bottom border on collapsed items ([23e00f5](https://github.com/telerik/kendo-themes/commit/23e00f5))
* **scheduler:** columns layout in material theme ([20b31c9](https://github.com/telerik/kendo-themes/commit/20b31c9))
* **scheduler:** header items focus state styles ([7516d9c](https://github.com/telerik/kendo-themes/commit/7516d9c))
* **scheduler:** incorrect inverse color for event title [#168](https://github.com/telerik/kendo-themes/issues/168) ([b2b2a81](https://github.com/telerik/kendo-themes/commit/b2b2a81))
* **scheduler:** navigation focus state ([9e5b372](https://github.com/telerik/kendo-themes/commit/9e5b372))
* **spreadsheet:** filter menu sort icons ([f9d09ab](https://github.com/telerik/kendo-themes/commit/f9d09ab))




<a name="3.2.0"></a>
# [3.2.0](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@3.1.0...@progress/kendo-theme-bootstrap@3.2.0) (2019-01-15)


### Bug Fixes

* **popup:** group header styles ([7032efe](https://github.com/telerik/kendo-themes/commit/7032efe))


### Features

* **datetimepicker:** add styles for kendo-react ([1aea521](https://github.com/telerik/kendo-themes/commit/1aea521))




<a name="3.1.0"></a>
# [3.1.0](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@3.0.0...@progress/kendo-theme-bootstrap@3.1.0) (2019-01-14)


### Bug Fixes

* **pager:** hover bg color ([bda7b56](https://github.com/telerik/kendo-themes/commit/bda7b56))


### Features

* add prebuilt swatches to npm package ([5962540](https://github.com/telerik/kendo-themes/commit/5962540)), closes [#36](https://github.com/telerik/kendo-themes/issues/36)




<a name="3.0.0"></a>
# [3.0.0](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@2.18.0...@progress/kendo-theme-bootstrap@3.0.0) (2019-01-08)


### Features

* **switch:** improvements based on the latest design ([2a1dcec](https://github.com/telerik/kendo-themes/commit/2a1dcec))


### BREAKING CHANGES

* **switch:** Improve switch rendering and remove javascript animations




<a name="2.18.0"></a>
# 2.18.0 (2019-01-07)


### Bug Fixes

* improve clear icon position in dropdowns and pickers ([f83db0f](https://github.com/telerik/kendo-themes/commit/f83db0f))
* **calendar:** remove material header buttons shadow ([1396eec](https://github.com/telerik/kendo-themes/commit/1396eec))
* **dialog:** improve button layouts ([37c988d](https://github.com/telerik/kendo-themes/commit/37c988d))
* **grid:** drag clue styles improvements [#252](https://github.com/telerik/kendo-themes/issues/252) ([780ff12](https://github.com/telerik/kendo-themes/commit/780ff12))
* **grid:** filter menu buttons margin and borders ([471c5b2](https://github.com/telerik/kendo-themes/commit/471c5b2))
* **scrollview:** trigger build ([a209ce2](https://github.com/telerik/kendo-themes/commit/a209ce2))
* **window:** window actions are not properly aligned in IE ([c2f6f6b](https://github.com/telerik/kendo-themes/commit/c2f6f6b))


### Features

* add predefined widths for Window and Dialog ([18cab9c](https://github.com/telerik/kendo-themes/commit/18cab9c))
* responsive pager jQuery ([9baeefc](https://github.com/telerik/kendo-themes/commit/9baeefc))




<a name="2.17.1"></a>
## [2.17.1](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@2.17.0...@progress/kendo-theme-bootstrap@2.17.1) (2018-12-07)


### Bug Fixes

* **material:** improve window appearance in dark themes ([ad56d1e](https://github.com/telerik/kendo-themes/commit/ad56d1e))
* **pager:** expose and use pager variables ([a09f6f4](https://github.com/telerik/kendo-themes/commit/a09f6f4))
* **scrollview:** revert regression rendering changes ([398412c](https://github.com/telerik/kendo-themes/commit/398412c))




<a name="2.17.0"></a>
# [2.17.0](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@2.16.0...@progress/kendo-theme-bootstrap@2.17.0) (2018-11-22)


### Bug Fixes

* **grid:** non-scrollable grid command buttons margins ([43e18ba](https://github.com/telerik/kendo-themes/commit/43e18ba)), closes [#426](https://github.com/telerik/kendo-themes/issues/426)


### Features

* **grid:** add hover + selected rows styles ([7dde502](https://github.com/telerik/kendo-themes/commit/7dde502))




<a name="2.16.0"></a>
# [2.16.0](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@2.15.0...@progress/kendo-theme-bootstrap@2.16.0) (2018-11-09)


### Bug Fixes

* **scheduler:** adaptive view switcher background ([41bdb94](https://github.com/telerik/kendo-themes/commit/41bdb94))
* **scheduler:** use :hover for buttons ([e296270](https://github.com/telerik/kendo-themes/commit/e296270))


### Features

* add kendo-theme-tasks ([61bda89](https://github.com/telerik/kendo-themes/commit/61bda89))




<a name="2.15.0"></a>
# [2.15.0](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@2.14.3...@progress/kendo-theme-bootstrap@2.15.0) (2018-10-31)


### Features

* **multiviewcalendar:** add multiviewcalendar for kendo-jquery ([9761e30](https://github.com/telerik/kendo-themes/commit/9761e30))




<a name="2.14.3"></a>
## [2.14.3](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@2.14.2...@progress/kendo-theme-bootstrap@2.14.3) (2018-10-29)




**Note:** Version bump only for package @progress/kendo-theme-bootstrap

<a name="2.14.2"></a>
## 2.14.2 (2018-10-16)


### Bug Fixes

* **inputs:** apply invalid state only trough class name instead of pseudo class ([4e0c8a2](https://github.com/telerik/kendo-themes/commit/4e0c8a2))
* **pager:** font-size and alignment corrections ([d44c8dd](https://github.com/telerik/kendo-themes/commit/d44c8dd))
* **pager:** use correct border radius in first / last links when in rtl ([ec3d97d](https://github.com/telerik/kendo-themes/commit/ec3d97d))
* **tabstrip:** extract tabstrip variables and use correct values ([699be9c](https://github.com/telerik/kendo-themes/commit/699be9c))




<a name="2.14.1"></a>
## [2.14.1](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@2.14.0...@progress/kendo-theme-bootstrap@2.14.1) (2018-10-01)


### Bug Fixes

* correct a typo in variable name ([0b1938c](https://github.com/telerik/kendo-themes/commit/0b1938c))




<a name="2.14.0"></a>
# 2.14.0 (2018-09-11)


### Bug Fixes

* **combobox:** incorrect styling when importing styles separately ([16da3d5](https://github.com/telerik/kendo-themes/commit/16da3d5))
* **multiselect:** incorrect styling when importing styles separately ([e5ea1ed](https://github.com/telerik/kendo-themes/commit/e5ea1ed))
* **tooltip:** incorrect styling when importing styles separately ([#304](https://github.com/telerik/kendo-themes/issues/304)) ([f78ff85](https://github.com/telerik/kendo-themes/commit/f78ff85))
* improve form variables in accordance to material design ([dcb5a44](https://github.com/telerik/kendo-themes/commit/dcb5a44))


### Features

* add themes for dropdowngrid ([d4171f0](https://github.com/telerik/kendo-themes/commit/d4171f0))
* **spreadsheet:** add Material theme ([#275](https://github.com/telerik/kendo-themes/issues/275)) ([043d7ed](https://github.com/telerik/kendo-themes/commit/043d7ed))




<a name="2.13.8"></a>
## 2.13.8 (2018-08-22)


### Bug Fixes

* **buttons:** remove box-shadow of active outline buttons ([#238](https://github.com/telerik/kendo-themes/issues/238)) ([ff5708f](https://github.com/telerik/kendo-themes/commit/ff5708f)), closes [telerik/kendo-themes#237](https://github.com/telerik/kendo-themes/issues/237)
* relax Bootstrap framework version requirement ([08a15b3](https://github.com/telerik/kendo-themes/commit/08a15b3))
* **progressbar:** use repeating gradient for indeterminate state ([d16368c](https://github.com/telerik/kendo-themes/commit/d16368c))




<a name="2.13.7"></a>
## [2.13.7](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@2.13.6...@progress/kendo-theme-bootstrap@2.13.7) (2018-07-24)




**Note:** Version bump only for package @progress/kendo-theme-bootstrap

<a name="2.13.6"></a>
## [2.13.6](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@2.13.5...@progress/kendo-theme-bootstrap@2.13.6) (2018-06-18)


### Bug Fixes

* **calendar:** error when compiling standalone calendar ([67aa44a](https://github.com/telerik/kendo-themes/commit/67aa44a))
* **tooltip:** align closable tooltip icon button ([69f2d09](https://github.com/telerik/kendo-themes/commit/69f2d09))




<a name="2.13.5"></a>
## [2.13.5](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@2.13.4...@progress/kendo-theme-bootstrap@2.13.5) (2018-05-23)


### Bug Fixes

* **notification:** add Material styles, improve close icon positioning ([5340230](https://github.com/telerik/kendo-themes/commit/5340230))




<a name="2.13.4"></a>
## [2.13.4](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@2.13.3...@progress/kendo-theme-bootstrap@2.13.4) (2018-05-16)




**Note:** Version bump only for package @progress/kendo-theme-bootstrap

<a name="2.13.3"></a>
## [2.13.3](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@2.13.2...@progress/kendo-theme-bootstrap@2.13.3) (2018-05-15)




**Note:** Version bump only for package @progress/kendo-theme-bootstrap

<a name="2.13.2"></a>
## [2.13.2](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@2.13.1...@progress/kendo-theme-bootstrap@2.13.2) (2018-05-10)




**Note:** Version bump only for package @progress/kendo-theme-bootstrap

<a name="2.13.1"></a>
## [2.13.1](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@2.13.0...@progress/kendo-theme-bootstrap@2.13.1) (2018-05-09)




**Note:** Version bump only for package @progress/kendo-theme-bootstrap

<a name="2.13.0"></a>
# 2.13.0 (2018-05-07)


### Features

* add TabStrip styling ([a93d7cc](https://github.com/telerik/kendo-themes/commit/a93d7cc))
* **grid:** add Angular column menu styling ([38d9486](https://github.com/telerik/kendo-themes/commit/38d9486))




<a name="2.12.1"></a>
## [2.12.1](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@2.12.0...@progress/kendo-theme-bootstrap@2.12.1) (2018-04-30)


### Bug Fixes

* **chat:** resolve missing file error when building from source ([#148](https://github.com/telerik/kendo-themes/issues/148)) ([d72af65](https://github.com/telerik/kendo-themes/commit/d72af65))




<a name="2.12.0"></a>
# 2.12.0 (2018-04-27)


### Bug Fixes

* **grid:** improve grouping header layout in Angular ([1df42eb](https://github.com/telerik/kendo-themes/commit/1df42eb))
* **textarea:** use input appearance ([af44caf](https://github.com/telerik/kendo-themes/commit/af44caf))


### Features

* add styles for chat widget ([#146](https://github.com/telerik/kendo-themes/issues/146)) ([5729aec](https://github.com/telerik/kendo-themes/commit/5729aec))
* add styles for Material Upload ([0a183f4](https://github.com/telerik/kendo-themes/commit/0a183f4))




<a name="2.11.11"></a>
## 2.11.11 (2018-04-11)


### Bug Fixes

* **dateinput:** improve spinner layout to match numeric ([d8d0842](https://github.com/telerik/kendo-themes/commit/d8d0842))
* **listview:** Improve focused and selected state appearance of listview in accordance with design ([4225503](https://github.com/telerik/kendo-themes/commit/4225503))




<a name="2.11.10"></a>
## [2.11.10](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@2.11.9...@progress/kendo-theme-bootstrap@2.11.10) (2018-03-26)


### Bug Fixes

* **button:** improve styles for flat and bare look ([e2e8b7a](https://github.com/telerik/kendo-themes/commit/e2e8b7a))




<a name="2.11.9"></a>
## [2.11.9](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@2.11.8...@progress/kendo-theme-bootstrap@2.11.9) (2018-03-12)


### Bug Fixes

* **input:** show angular invalid state on touch/dirty ([a7dbc4d](https://github.com/telerik/kendo-themes/commit/a7dbc4d)), closes [telerik/kendo-theme-bootstrap#369](https://github.com/telerik/kendo-theme-bootstrap/issues/369)




<a name="2.11.8"></a>
## [2.11.8](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@2.11.7...@progress/kendo-theme-bootstrap@2.11.8) (2018-02-20)




**Note:** Version bump only for package @progress/kendo-theme-bootstrap

<a name="2.11.7"></a>
## [2.11.7](https://github.com/telerik/kendo-themes/compare/@progress/kendo-theme-bootstrap@2.11.6...@progress/kendo-theme-bootstrap@2.11.7) (2018-02-16)


### Bug Fixes

* **editor:** add styles for editor table telerik/kendo[#8213](https://github.com/telerik/kendo-themes/issues/8213) ([5cec16a](https://github.com/telerik/kendo-themes/commit/5cec16a))




<a name="2.11.6"></a>
## [2.11.6](https://github.com/telerik/kendo-theme-bootstrap/compare/@progress/kendo-theme-bootstrap@2.11.5...@progress/kendo-theme-bootstrap@2.11.6) (2018-02-13)




**Note:** Version bump only for package @progress/kendo-theme-bootstrap

<a name="2.11.5"></a>
## [2.11.5](https://github.com/telerik/kendo-theme-bootstrap/compare/@progress/kendo-theme-bootstrap@2.11.4...@progress/kendo-theme-bootstrap@2.11.5) (2018-02-06)




**Note:** Version bump only for package @progress/kendo-theme-bootstrap

<a name="2.11.4"></a>
## [2.11.4](https://github.com/telerik/kendo-theme-bootstrap/compare/@progress/kendo-theme-bootstrap@2.11.3...@progress/kendo-theme-bootstrap@2.11.4) (2018-02-06)


### Bug Fixes

* **package:** reduce npm package size for derived themes ([d4a2ad9](https://github.com/telerik/kendo-theme-bootstrap/commit/d4a2ad9))




<a name="2.11.3"></a>
## [2.11.3](https://github.com/telerik/kendo-theme-bootstrap/compare/@progress/kendo-theme-bootstrap@2.11.2...@progress/kendo-theme-bootstrap@2.11.3) (2018-02-06)




**Note:** Version bump only for package @progress/kendo-theme-bootstrap

<a name="3.0.0"></a>
# 3.0.0 (2018-01-30)


### Bug Fixes

* add bootstrap overrides and update variables ([0a81bc0](https://github.com/telerik/kendo-theme-bootstrap/commit/0a81bc0))
* add dependencies to bootstrap variables to all components ([912e821](https://github.com/telerik/kendo-theme-bootstrap/commit/912e821))
* add dirty collapse / expand icons. unifiy icon pseudo elements ([dd8fa00](https://github.com/telerik/kendo-theme-bootstrap/commit/dd8fa00))
* add global options variables for rounded corners, shadows, gradients and transitions ([7fbd9b1](https://github.com/telerik/kendo-theme-bootstrap/commit/7fbd9b1))
* add styles for missing chart components ([e07ec09](https://github.com/telerik/kendo-theme-bootstrap/commit/e07ec09))
* add styles for selected tabstrip pane ([32143f0](https://github.com/telerik/kendo-theme-bootstrap/commit/32143f0))
* allow package to work outside of webpack ([f330d67](https://github.com/telerik/kendo-theme-bootstrap/commit/f330d67))
* border and text decorations ([2c45e1f](https://github.com/telerik/kendo-theme-bootstrap/commit/2c45e1f))
* consolidate picker form controls ([3a01dc4](https://github.com/telerik/kendo-theme-bootstrap/commit/3a01dc4))
* correct classnames for seek icons ([0ce684a](https://github.com/telerik/kendo-theme-bootstrap/commit/0ce684a))
* correct main file name in NPM package ([c6feade](https://github.com/telerik/kendo-theme-bootstrap/commit/c6feade))
* correct path for editor import ([bb8954c](https://github.com/telerik/kendo-theme-bootstrap/commit/bb8954c))
* define all inherited variables when importing component files ([3e1e3a2](https://github.com/telerik/kendo-theme-bootstrap/commit/3e1e3a2))
* duplicate selectors in switch widget styles so kendo-ng-* can use them ([42b4f96](https://github.com/telerik/kendo-theme-bootstrap/commit/42b4f96))
* grid alt and selected state ([7052156](https://github.com/telerik/kendo-theme-bootstrap/commit/7052156))
* improve styles for days ([778f9ec](https://github.com/telerik/kendo-theme-bootstrap/commit/778f9ec))
* improve styles in switch for angular ([409fb25](https://github.com/telerik/kendo-theme-bootstrap/commit/409fb25))
* improve volume slider styles ([8a30252](https://github.com/telerik/kendo-theme-bootstrap/commit/8a30252))
* include color functions in the variables file ([07975f2](https://github.com/telerik/kendo-theme-bootstrap/commit/07975f2))
* inline Editor border width and select state ([aea000b](https://github.com/telerik/kendo-theme-bootstrap/commit/aea000b))
* make theme work with kendo-theme-default@2.x ([44e2ee5](https://github.com/telerik/kendo-theme-bootstrap/commit/44e2ee5))
* missing handle icon and background of splitbar in normal state ([6878f70](https://github.com/telerik/kendo-theme-bootstrap/commit/6878f70))
* **MaskedTextbox:** Fix invalid state border ([9d559cb](https://github.com/telerik/kendo-theme-bootstrap/commit/9d559cb))
* pager and dropdownlist appearance ([a33c910](https://github.com/telerik/kendo-theme-bootstrap/commit/a33c910))
* reduce toolbar padding ([56b4e30](https://github.com/telerik/kendo-theme-bootstrap/commit/56b4e30))
* remove extra borders of button groups and fix border color of selected button ([8930df8](https://github.com/telerik/kendo-theme-bootstrap/commit/8930df8))
* remove focus box-shadow from editors ([56386c4](https://github.com/telerik/kendo-theme-bootstrap/commit/56386c4))
* specify transition properties ([3224751](https://github.com/telerik/kendo-theme-bootstrap/commit/3224751)), closes [#198](https://github.com/telerik/kendo-theme-bootstrap/issues/198)
* splitter does not apply styles for hover state ([ccd3303](https://github.com/telerik/kendo-theme-bootstrap/commit/ccd3303))
* stop using css modules via common-tasks 2.0 ([04ef5ee](https://github.com/telerik/kendo-theme-bootstrap/commit/04ef5ee))
* **button:** improve outline button appearance ([a634d3e](https://github.com/telerik/kendo-theme-bootstrap/commit/a634d3e))
* **button:** use correct colors for primary button ([89d803d](https://github.com/telerik/kendo-theme-bootstrap/commit/89d803d))
* **buttonGroup:** fix no applying focus state to disabled button in button group telerik/kendo[#7846](https://github.com/telerik/kendo-theme-bootstrap/issues/7846) ([c64cbd7](https://github.com/telerik/kendo-theme-bootstrap/commit/c64cbd7))
* **calendar:** add styles for infinite calendar ([abee18c](https://github.com/telerik/kendo-theme-bootstrap/commit/abee18c))
* **calendar:** update calendar appearance in accordance to Bootstrap v4 beta-1 ([5779cd9](https://github.com/telerik/kendo-theme-bootstrap/commit/5779cd9))
* **chart:** grid lines colors ([#102](https://github.com/telerik/kendo-theme-bootstrap/issues/102)) ([7e2361d](https://github.com/telerik/kendo-theme-bootstrap/commit/7e2361d))
* **combobox:** rtl appearance ([9970562](https://github.com/telerik/kendo-theme-bootstrap/commit/9970562))
* **combobox:** wrong border colors of focused combobox ([3774304](https://github.com/telerik/kendo-theme-bootstrap/commit/3774304))
* **common:** improve header variables ([b0b54e6](https://github.com/telerik/kendo-theme-bootstrap/commit/b0b54e6))
* **common:** update dependency to Bootstrap v4 beta-2 ([0c50b53](https://github.com/telerik/kendo-theme-bootstrap/commit/0c50b53))
* **contextmenu:** update contextmenu appearance ([a416da7](https://github.com/telerik/kendo-theme-bootstrap/commit/a416da7))
* **dateinput:** border, hover and focus state ([08b753c](https://github.com/telerik/kendo-theme-bootstrap/commit/08b753c))
* **dateinputs:** apply consistent header styles ([c2b7d5f](https://github.com/telerik/kendo-theme-bootstrap/commit/c2b7d5f))
* **datetimepicker:** wrong focus state borders colors ([687c955](https://github.com/telerik/kendo-theme-bootstrap/commit/687c955))
* **dropdown:** add focus state to dropdown and popup ([9ce99ab](https://github.com/telerik/kendo-theme-bootstrap/commit/9ce99ab))
* **dropdownlist:** apply color to option label border ([ececc25](https://github.com/telerik/kendo-theme-bootstrap/commit/ececc25))
* **editors:** common layout glitches ([5b588d2](https://github.com/telerik/kendo-theme-bootstrap/commit/5b588d2))
* **forms:** align forms in dialog labels. ([61c881d](https://github.com/telerik/kendo-theme-bootstrap/commit/61c881d))
* **gantt:** improve milestone appearance ([df7c9a1](https://github.com/telerik/kendo-theme-bootstrap/commit/df7c9a1))
* **gantt:** make task resize handler wider and transparent ([af62568](https://github.com/telerik/kendo-theme-bootstrap/commit/af62568))
* **gantt:** reduce padding of toolbar-like elements in gantt ([fd945e2](https://github.com/telerik/kendo-theme-bootstrap/commit/fd945e2))
* **gantt:** view switcher is missing selected state ([2c19585](https://github.com/telerik/kendo-theme-bootstrap/commit/2c19585))
* **grid:** Add dirty cell indicator styling ([e75eca0](https://github.com/telerik/kendo-theme-bootstrap/commit/e75eca0))
* **grid:** Add missing locked footer border color ([e5caf33](https://github.com/telerik/kendo-theme-bootstrap/commit/e5caf33))
* **grid:** Add RTL styles for dirty cells ([266ebc7](https://github.com/telerik/kendo-theme-bootstrap/commit/266ebc7))
* **grid:** border color ([1923fff](https://github.com/telerik/kendo-theme-bootstrap/commit/1923fff))
* **grid:** Fix edit textbox width variable ([598e451](https://github.com/telerik/kendo-theme-bootstrap/commit/598e451))
* **grid:** improve grid row selected state ([1150dad](https://github.com/telerik/kendo-theme-bootstrap/commit/1150dad))
* **grid:** reduce padding of toolbar-like elements in grid ([cf25e3c](https://github.com/telerik/kendo-theme-bootstrap/commit/cf25e3c))
* **grid:** remove focus on header links ([96637a2](https://github.com/telerik/kendo-theme-bootstrap/commit/96637a2))
* **grid:** Remove selection column checkbox margin in RTL ([c671f29](https://github.com/telerik/kendo-theme-bootstrap/commit/c671f29))
* **grid:** scope selcted styles ([be070f9](https://github.com/telerik/kendo-theme-bootstrap/commit/be070f9))
* **grid:** Set fixed font-size of col sorting index to achieve alignment ([e8aef0b](https://github.com/telerik/kendo-theme-bootstrap/commit/e8aef0b))
* **grid:** Tweak multiple column sorting index position ([787d70e](https://github.com/telerik/kendo-theme-bootstrap/commit/787d70e))
* **grid:** use scoped grid variables ([7c12b76](https://github.com/telerik/kendo-theme-bootstrap/commit/7c12b76))
* **Grid:** Add cell focused state styles ([0c3fd96](https://github.com/telerik/kendo-theme-bootstrap/commit/0c3fd96))
* **Grid:** Add styles for verification tooltip ([c2b1f8a](https://github.com/telerik/kendo-theme-bootstrap/commit/c2b1f8a))
* **input:** Add styles for placeholder text ([9ea8b70](https://github.com/telerik/kendo-theme-bootstrap/commit/9ea8b70))
* **inputs:** wrong border color for invalid inputs ([c62ea18](https://github.com/telerik/kendo-theme-bootstrap/commit/c62ea18)), closes [telerik/kendo-theme-bootstrap#289](https://github.com/telerik/kendo-theme-bootstrap/issues/289)
* **listbox:** use correct variables for listbox ([f863af3](https://github.com/telerik/kendo-theme-bootstrap/commit/f863af3))
* **ListBox:** Improve button margins temporarily ([005ce87](https://github.com/telerik/kendo-theme-bootstrap/commit/005ce87))
* **listview:** add focused state ([b5d0c07](https://github.com/telerik/kendo-theme-bootstrap/commit/b5d0c07))
* **map:** Add marker color ([c958ace](https://github.com/telerik/kendo-theme-bootstrap/commit/c958ace))
* **map:** directions navigator is not properly customized in themebuilder ([502028d](https://github.com/telerik/kendo-theme-bootstrap/commit/502028d))
* **MaskedTextbox:** Add missing invalid state border ([2b9a72b](https://github.com/telerik/kendo-theme-bootstrap/commit/2b9a72b))
* **mediaplayer:** add opacity to toolbar ([d0aa7bc](https://github.com/telerik/kendo-theme-bootstrap/commit/d0aa7bc))
* **menu:** add styles for scrolling ([aa4a878](https://github.com/telerik/kendo-theme-bootstrap/commit/aa4a878))
* **multiselect:** border color ([d620f57](https://github.com/telerik/kendo-theme-bootstrap/commit/d620f57))
* **multiselect:** improve height of token with empty string telerik/kendo-ui-core[#372](https://github.com/telerik/kendo-theme-bootstrap/issues/372) ([a050374](https://github.com/telerik/kendo-theme-bootstrap/commit/a050374))
* **multiselect:** wrong items height ([a5c6116](https://github.com/telerik/kendo-theme-bootstrap/commit/a5c6116))
* **notification:** use panel styles for default type ([91ca341](https://github.com/telerik/kendo-theme-bootstrap/commit/91ca341))
* **notification:** use scoped variables for notification ([96b2c2c](https://github.com/telerik/kendo-theme-bootstrap/commit/96b2c2c))
* **numerictextbox:** spinners misalignment ([d89d006](https://github.com/telerik/kendo-theme-bootstrap/commit/d89d006))
* **pager:** add focus outline for pager buttons ([316ff9b](https://github.com/telerik/kendo-theme-bootstrap/commit/316ff9b))
* **pager:** focused state text decoration ([82fa821](https://github.com/telerik/kendo-theme-bootstrap/commit/82fa821))
* **pager:** improve disabled state of pager items ([18922d1](https://github.com/telerik/kendo-theme-bootstrap/commit/18922d1))
* **pager:** improve selected styles ([86b5726](https://github.com/telerik/kendo-theme-bootstrap/commit/86b5726))
* **pager:** use consistent header appearance ([a6ae6cd](https://github.com/telerik/kendo-theme-bootstrap/commit/a6ae6cd))
* **pager:** use relative units for button metrics ([#267](https://github.com/telerik/kendo-theme-bootstrap/issues/267)) ([bc5d7d3](https://github.com/telerik/kendo-theme-bootstrap/commit/bc5d7d3))
* **panelbar:** improve focus state ([54497f8](https://github.com/telerik/kendo-theme-bootstrap/commit/54497f8))
* **panelbar:** use correct border color for root items ([7dd7582](https://github.com/telerik/kendo-theme-bootstrap/commit/7dd7582))
* **pivotgrid:** apply header-bg to pivotgrid configurator ([381406a](https://github.com/telerik/kendo-theme-bootstrap/commit/381406a))
* **pivotgrid:** reduce padding of toolbar-like elements in pivotgrid ([8af6287](https://github.com/telerik/kendo-theme-bootstrap/commit/8af6287))
* **pivotgrid:** use correct color for pivotgrid toolbar border ([9f0fb06](https://github.com/telerik/kendo-theme-bootstrap/commit/9f0fb06))
* **Popup:** Remove the top and bottom padding of Popup when used as a column menu ([5b0ed95](https://github.com/telerik/kendo-theme-bootstrap/commit/5b0ed95))
* **progressbar:** add styles for indetermined progressbar ([e13a6c4](https://github.com/telerik/kendo-theme-bootstrap/commit/e13a6c4))
* **progressbar:** use correct variables for progressbar ([7bcdc0c](https://github.com/telerik/kendo-theme-bootstrap/commit/7bcdc0c))
* **ripple:** add default ripple styles ([19d1c09](https://github.com/telerik/kendo-theme-bootstrap/commit/19d1c09))
* **scheduler:** add bacground to event with no resources ([5fa6a29](https://github.com/telerik/kendo-theme-bootstrap/commit/5fa6a29))
* **scheduler:** view switcher is missing selected state ([9abcf35](https://github.com/telerik/kendo-theme-bootstrap/commit/9abcf35))
* **scrollview:** add styles for scrollview pager ([e79ecb8](https://github.com/telerik/kendo-theme-bootstrap/commit/e79ecb8))
* **slider:** add focus state to drag handle ([8208d0a](https://github.com/telerik/kendo-theme-bootstrap/commit/8208d0a))
* **slider:** add tick images ([80ed313](https://github.com/telerik/kendo-theme-bootstrap/commit/80ed313))
* **slider:** link slider variables to progressbar variables ([0ede195](https://github.com/telerik/kendo-theme-bootstrap/commit/0ede195))
* **slider:** remove browser outline on focus ([dc7fd03](https://github.com/telerik/kendo-theme-bootstrap/commit/dc7fd03))
* **splitter:** use correct colors for splitter ([2ff9472](https://github.com/telerik/kendo-theme-bootstrap/commit/2ff9472))
* **spreadsheet:** add styles for filter menu and filter button ([05ea173](https://github.com/telerik/kendo-theme-bootstrap/commit/05ea173))
* **spreadsheet:** improve spreadsheet active cell border by frozen cells telerik/kendo-ui-core[#3254](https://github.com/telerik/kendo-theme-bootstrap/issues/3254) ([0d838c3](https://github.com/telerik/kendo-theme-bootstrap/commit/0d838c3))
* **spreadsheet:** make drag handle to be visible in all cases telerik/kendo-ui-core[#3254](https://github.com/telerik/kendo-theme-bootstrap/issues/3254) ([4fdeafc](https://github.com/telerik/kendo-theme-bootstrap/commit/4fdeafc))
* **spreadsheet:** missing indicators for spreadsheet ([18ff11d](https://github.com/telerik/kendo-theme-bootstrap/commit/18ff11d))
* **spreadsheet:** styles for spreadsheet toolbar ([7e51ad7](https://github.com/telerik/kendo-theme-bootstrap/commit/7e51ad7))
* **switch:** border-color of switch is too dark ([1659185](https://github.com/telerik/kendo-theme-bootstrap/commit/1659185))
* wrong border color of input in scheduler advanced form ([eaf5e48](https://github.com/telerik/kendo-theme-bootstrap/commit/eaf5e48))
* **switch:** use correct border-radius for switch wrapper ([11f697e](https://github.com/telerik/kendo-theme-bootstrap/commit/11f697e))
* **tabstrip:** update variables to reflect changes in bootstrap ([fc60359](https://github.com/telerik/kendo-theme-bootstrap/commit/fc60359))
* **tabstrip:** use correct border-color when hovering / selecting tabs ([66709a7](https://github.com/telerik/kendo-theme-bootstrap/commit/66709a7))
* **timepicker:** improve popup appearance ([#348](https://github.com/telerik/kendo-theme-bootstrap/issues/348)) ([19e3965](https://github.com/telerik/kendo-theme-bootstrap/commit/19e3965))
* **tooltip:** tooltip cannot be customized in theme builder ([8e220c7](https://github.com/telerik/kendo-theme-bootstrap/commit/8e220c7))
* **tooltip:** use $font-size-sm ([c40001f](https://github.com/telerik/kendo-theme-bootstrap/commit/c40001f))
* **tooltip:** use alert-padding for close button ([2b130c7](https://github.com/telerik/kendo-theme-bootstrap/commit/2b130c7))
* **tooltip:** use contrast function to determine text color based on background ([6bc6c12](https://github.com/telerik/kendo-theme-bootstrap/commit/6bc6c12))
* **tooltip:** use correct padding for collapsible tooltip ([20ec0ad](https://github.com/telerik/kendo-theme-bootstrap/commit/20ec0ad))
* **tooltip:** use tooltip font-size variable ([53b2864](https://github.com/telerik/kendo-theme-bootstrap/commit/53b2864))
* **treeview:** add additional spacing around nodes so box shadow dont overlap ([260a216](https://github.com/telerik/kendo-theme-bootstrap/commit/260a216))
* **treeview:** add border radius to nodes ([184301c](https://github.com/telerik/kendo-theme-bootstrap/commit/184301c))
* **treeview:** focused and selected-focused state are clipped ([56e9445](https://github.com/telerik/kendo-theme-bootstrap/commit/56e9445))
* **treeview:** improve node colors ([9885066](https://github.com/telerik/kendo-theme-bootstrap/commit/9885066))
* **treeview:** reduce spacing between checkbox and item text ([b6426fc](https://github.com/telerik/kendo-theme-bootstrap/commit/b6426fc))
* **upload:** import theme styles from the default theme ([6e330aa](https://github.com/telerik/kendo-theme-bootstrap/commit/6e330aa))
* **window:** add spacing between buttons ([cbd9223](https://github.com/telerik/kendo-theme-bootstrap/commit/cbd9223))
* **window:** fix content bleeding outside of window boundaries ([932c9a7](https://github.com/telerik/kendo-theme-bootstrap/commit/932c9a7))
* **window:** increase window actions padding ([0709998](https://github.com/telerik/kendo-theme-bootstrap/commit/0709998))
* **window:** reduce window action size ([e450346](https://github.com/telerik/kendo-theme-bootstrap/commit/e450346))
* use Listing D:\WORK\kendo-ui\kendo-theme-bootstrap\ New files added to this directory will not be compressed. ([ca44855](https://github.com/telerik/kendo-theme-bootstrap/commit/ca44855))
* **window:** remove box shadow ([2331805](https://github.com/telerik/kendo-theme-bootstrap/commit/2331805))
* switch appearance ([24bb58e](https://github.com/telerik/kendo-theme-bootstrap/commit/24bb58e))
* switch label alignment ([0233b20](https://github.com/telerik/kendo-theme-bootstrap/commit/0233b20))
* Switch to a variable from pixels for font-size of col sorting index text ([55d1140](https://github.com/telerik/kendo-theme-bootstrap/commit/55d1140))
* Switch to separate vars for alert vertical / horizontal padding ([8976522](https://github.com/telerik/kendo-theme-bootstrap/commit/8976522))
* unify design of dialog buttons and action buttons ([a8b8f21](https://github.com/telerik/kendo-theme-bootstrap/commit/a8b8f21))
* unify theme entrypoint name ([1e11ce0](https://github.com/telerik/kendo-theme-bootstrap/commit/1e11ce0))
* update dependencies on build ([c2f835f](https://github.com/telerik/kendo-theme-bootstrap/commit/c2f835f))
* update license ([#277](https://github.com/telerik/kendo-theme-bootstrap/issues/277)) ([f8a0fab](https://github.com/telerik/kendo-theme-bootstrap/commit/f8a0fab))
* update spacer-x / y variables ([9987287](https://github.com/telerik/kendo-theme-bootstrap/commit/9987287))
* update variables for themebuilder ([a7cafcc](https://github.com/telerik/kendo-theme-bootstrap/commit/a7cafcc))
* use ~ paths to reference node_modules ([7bfa24d](https://github.com/telerik/kendo-theme-bootstrap/commit/7bfa24d))
* use bootstrap component-* variables for theme base variables ([130b46f](https://github.com/telerik/kendo-theme-bootstrap/commit/130b46f))
* use box sizing for autocomplete ([0ccb3e8](https://github.com/telerik/kendo-theme-bootstrap/commit/0ccb3e8))
* use correct import path for media player ([fc7ef6f](https://github.com/telerik/kendo-theme-bootstrap/commit/fc7ef6f))
* use correct selectors for focused state ([fec9aae](https://github.com/telerik/kendo-theme-bootstrap/commit/fec9aae))
* use correct values for grid-padding and toolbar-padding ([3b1656a](https://github.com/telerik/kendo-theme-bootstrap/commit/3b1656a))
* use new contrast function ([6df8a35](https://github.com/telerik/kendo-theme-bootstrap/commit/6df8a35))
* use new contrast function ([c8936af](https://github.com/telerik/kendo-theme-bootstrap/commit/c8936af))
* use the correct box sizing for pager ([b939a69](https://github.com/telerik/kendo-theme-bootstrap/commit/b939a69))
* **window:** use correct border color for window ([23f90ff](https://github.com/telerik/kendo-theme-bootstrap/commit/23f90ff))
* use the correct box-sizing for colorpicker ([13233f1](https://github.com/telerik/kendo-theme-bootstrap/commit/13233f1))
* use the correct box-sizing for slider ([e572252](https://github.com/telerik/kendo-theme-bootstrap/commit/e572252))
* **window:** use opacity for window action buttons ([edc9733](https://github.com/telerik/kendo-theme-bootstrap/commit/edc9733))
* **window:** use scoped variables for window ([d56f591](https://github.com/telerik/kendo-theme-bootstrap/commit/d56f591))
* varibles are not properly set ([b3257c9](https://github.com/telerik/kendo-theme-bootstrap/commit/b3257c9))
* various editor fixes ([f16bfbe](https://github.com/telerik/kendo-theme-bootstrap/commit/f16bfbe))
* various fixes in navigation control ([f8ad8f7](https://github.com/telerik/kendo-theme-bootstrap/commit/f8ad8f7))


### Features

* add fill and outline utility mixins ([0e003c7](https://github.com/telerik/kendo-theme-bootstrap/commit/0e003c7))
* Add ListBox styles ([f372ac9](https://github.com/telerik/kendo-theme-bootstrap/commit/f372ac9))
* add media player ([f68e2f5](https://github.com/telerik/kendo-theme-bootstrap/commit/f68e2f5))
* add pivotgrid styles ([e777abf](https://github.com/telerik/kendo-theme-bootstrap/commit/e777abf))
* **button:** add styles for outline button ([b87efdc](https://github.com/telerik/kendo-theme-bootstrap/commit/b87efdc))
* add styles for dialog component ([9401341](https://github.com/telerik/kendo-theme-bootstrap/commit/9401341))
* add styles for gantt ([d463033](https://github.com/telerik/kendo-theme-bootstrap/commit/d463033))
* Add styles for inline Editor ([33f4422](https://github.com/telerik/kendo-theme-bootstrap/commit/33f4422))
* add styles for map ([f7ee367](https://github.com/telerik/kendo-theme-bootstrap/commit/f7ee367))
* add styles for spreadsheet closes [#47](https://github.com/telerik/kendo-theme-bootstrap/issues/47) ([8555777](https://github.com/telerik/kendo-theme-bootstrap/commit/8555777))
* add styling for forms ([#268](https://github.com/telerik/kendo-theme-bootstrap/issues/268)) ([5f65bfe](https://github.com/telerik/kendo-theme-bootstrap/commit/5f65bfe))
* add support for ng-chart colors ([1645717](https://github.com/telerik/kendo-theme-bootstrap/commit/1645717))
* embed dependencies during publish ([2b77ef9](https://github.com/telerik/kendo-theme-bootstrap/commit/2b77ef9))
* enable development channel ([0543ec3](https://github.com/telerik/kendo-theme-bootstrap/commit/0543ec3))
* extract dropdown wrap ([c51f240](https://github.com/telerik/kendo-theme-bootstrap/commit/c51f240))
* publish package with [@progress](https://github.com/progress) prefix ([5c7a061](https://github.com/telerik/kendo-theme-bootstrap/commit/5c7a061))
* remove 'base' mixin folder ([f230f4e](https://github.com/telerik/kendo-theme-bootstrap/commit/f230f4e))
* remove box-sizing override to better comply with 3rd party frameworks ([540e8d1](https://github.com/telerik/kendo-theme-bootstrap/commit/540e8d1))
* standartize folder structure ([e193234](https://github.com/telerik/kendo-theme-bootstrap/commit/e193234))
* styles for barcode and qrcode ([c852789](https://github.com/telerik/kendo-theme-bootstrap/commit/c852789))
* styles for scheduler ([a67afec](https://github.com/telerik/kendo-theme-bootstrap/commit/a67afec))
* styles for scrollview ([fdd5738](https://github.com/telerik/kendo-theme-bootstrap/commit/fdd5738))
* styles for table alignment and media player ([8d65e31](https://github.com/telerik/kendo-theme-bootstrap/commit/8d65e31))
* tie bootstrap dep to a specific commit (latest as of 2017/03/06) ([fd7c42e](https://github.com/telerik/kendo-theme-bootstrap/commit/fd7c42e))
* update bootstrap dependency to 4.0.0-beta ([#299](https://github.com/telerik/kendo-theme-bootstrap/issues/299)) ([2a99728](https://github.com/telerik/kendo-theme-bootstrap/commit/2a99728))
* **grid:** style grid filter button states ([543bbe9](https://github.com/telerik/kendo-theme-bootstrap/commit/543bbe9))
* update bootstrap dependency to v4.0.0 ([3f739c8](https://github.com/telerik/kendo-theme-bootstrap/commit/3f739c8))
* **badge:** add styles for badge telerik/kendo[#7846](https://github.com/telerik/kendo-theme-bootstrap/issues/7846) ([7cd13d2](https://github.com/telerik/kendo-theme-bootstrap/commit/7cd13d2))
* **button:** add styles for bare button ([ca29995](https://github.com/telerik/kendo-theme-bootstrap/commit/ca29995))
* **button:** add styles for flat button ([2b299b7](https://github.com/telerik/kendo-theme-bootstrap/commit/2b299b7))
* **button:** add styles for outline button ([ed1f492](https://github.com/telerik/kendo-theme-bootstrap/commit/ed1f492))
* **calendar:** implement design for kendo-angular ([73268ec](https://github.com/telerik/kendo-theme-bootstrap/commit/73268ec))
* **checkbox:** improve styles for checkboxes ([0afbdde](https://github.com/telerik/kendo-theme-bootstrap/commit/0afbdde))
* **DateInput:** Add invalid state styles ([627057c](https://github.com/telerik/kendo-theme-bootstrap/commit/627057c))
* **DatePicker:** Add DateInput invalid state ([81d3727](https://github.com/telerik/kendo-theme-bootstrap/commit/81d3727))
* **datetimepicker:** Add invalid state styles ([1a14bfa](https://github.com/telerik/kendo-theme-bootstrap/commit/1a14bfa))
* **edit-form:** add styles for edit form ([16a157c](https://github.com/telerik/kendo-theme-bootstrap/commit/16a157c))
* **grid:** Add styles for column sorting ([55abc0e](https://github.com/telerik/kendo-theme-bootstrap/commit/55abc0e))
* **Grid:** Add styles for Grid column sorting order ([85cdfb9](https://github.com/telerik/kendo-theme-bootstrap/commit/85cdfb9))
* **MaskedTextbox:** Add separate styles for MTB, invalid state (telerik/kendo[#6825](https://github.com/telerik/kendo-theme-bootstrap/issues/6825)) ([d1067b0](https://github.com/telerik/kendo-theme-bootstrap/commit/d1067b0))
* **numerictextbox:** add pressed state to increase/decrease arrows; align spinner icons ([47fa757](https://github.com/telerik/kendo-theme-bootstrap/commit/47fa757))
* **radiobutton:** improve styles for radio button ([1a6db60](https://github.com/telerik/kendo-theme-bootstrap/commit/1a6db60))
* **timepicker:** Add invalid state styles ([e22dd7f](https://github.com/telerik/kendo-theme-bootstrap/commit/e22dd7f))
* use mixins from [@telerik](https://github.com/telerik)/kendo-theme-default ([ed4c3d9](https://github.com/telerik/kendo-theme-bootstrap/commit/ed4c3d9))
* use pickerwrap for combo and dropdown ([85ed82d](https://github.com/telerik/kendo-theme-bootstrap/commit/85ed82d))


### BREAKING CHANGES

* Publish with @progress prefix




<a name="2.12.0-dev.c7ddd20b"></a>
# 2.12.0-dev.c7ddd20b (2018-01-30)


### Bug Fixes

* add bootstrap overrides and update variables ([0a81bc0](https://github.com/telerik/kendo-theme-bootstrap/commit/0a81bc0))
* add dependencies to bootstrap variables to all components ([912e821](https://github.com/telerik/kendo-theme-bootstrap/commit/912e821))
* add dirty collapse / expand icons. unifiy icon pseudo elements ([dd8fa00](https://github.com/telerik/kendo-theme-bootstrap/commit/dd8fa00))
* add global options variables for rounded corners, shadows, gradients and transitions ([7fbd9b1](https://github.com/telerik/kendo-theme-bootstrap/commit/7fbd9b1))
* add styles for missing chart components ([e07ec09](https://github.com/telerik/kendo-theme-bootstrap/commit/e07ec09))
* add styles for selected tabstrip pane ([32143f0](https://github.com/telerik/kendo-theme-bootstrap/commit/32143f0))
* allow package to work outside of webpack ([f330d67](https://github.com/telerik/kendo-theme-bootstrap/commit/f330d67))
* border and text decorations ([2c45e1f](https://github.com/telerik/kendo-theme-bootstrap/commit/2c45e1f))
* consolidate picker form controls ([3a01dc4](https://github.com/telerik/kendo-theme-bootstrap/commit/3a01dc4))
* correct classnames for seek icons ([0ce684a](https://github.com/telerik/kendo-theme-bootstrap/commit/0ce684a))
* correct main file name in NPM package ([c6feade](https://github.com/telerik/kendo-theme-bootstrap/commit/c6feade))
* correct path for editor import ([bb8954c](https://github.com/telerik/kendo-theme-bootstrap/commit/bb8954c))
* define all inherited variables when importing component files ([3e1e3a2](https://github.com/telerik/kendo-theme-bootstrap/commit/3e1e3a2))
* duplicate selectors in switch widget styles so kendo-ng-* can use them ([42b4f96](https://github.com/telerik/kendo-theme-bootstrap/commit/42b4f96))
* grid alt and selected state ([7052156](https://github.com/telerik/kendo-theme-bootstrap/commit/7052156))
* improve styles for days ([778f9ec](https://github.com/telerik/kendo-theme-bootstrap/commit/778f9ec))
* improve styles in switch for angular ([409fb25](https://github.com/telerik/kendo-theme-bootstrap/commit/409fb25))
* improve volume slider styles ([8a30252](https://github.com/telerik/kendo-theme-bootstrap/commit/8a30252))
* include color functions in the variables file ([07975f2](https://github.com/telerik/kendo-theme-bootstrap/commit/07975f2))
* inline Editor border width and select state ([aea000b](https://github.com/telerik/kendo-theme-bootstrap/commit/aea000b))
* make theme work with kendo-theme-default@2.x ([44e2ee5](https://github.com/telerik/kendo-theme-bootstrap/commit/44e2ee5))
* missing handle icon and background of splitbar in normal state ([6878f70](https://github.com/telerik/kendo-theme-bootstrap/commit/6878f70))
* **MaskedTextbox:** Fix invalid state border ([9d559cb](https://github.com/telerik/kendo-theme-bootstrap/commit/9d559cb))
* pager and dropdownlist appearance ([a33c910](https://github.com/telerik/kendo-theme-bootstrap/commit/a33c910))
* reduce toolbar padding ([56b4e30](https://github.com/telerik/kendo-theme-bootstrap/commit/56b4e30))
* remove extra borders of button groups and fix border color of selected button ([8930df8](https://github.com/telerik/kendo-theme-bootstrap/commit/8930df8))
* remove focus box-shadow from editors ([56386c4](https://github.com/telerik/kendo-theme-bootstrap/commit/56386c4))
* specify transition properties ([3224751](https://github.com/telerik/kendo-theme-bootstrap/commit/3224751)), closes [#198](https://github.com/telerik/kendo-theme-bootstrap/issues/198)
* splitter does not apply styles for hover state ([ccd3303](https://github.com/telerik/kendo-theme-bootstrap/commit/ccd3303))
* stop using css modules via common-tasks 2.0 ([04ef5ee](https://github.com/telerik/kendo-theme-bootstrap/commit/04ef5ee))
* **button:** improve outline button appearance ([a634d3e](https://github.com/telerik/kendo-theme-bootstrap/commit/a634d3e))
* **button:** use correct colors for primary button ([89d803d](https://github.com/telerik/kendo-theme-bootstrap/commit/89d803d))
* **buttonGroup:** fix no applying focus state to disabled button in button group telerik/kendo[#7846](https://github.com/telerik/kendo-theme-bootstrap/issues/7846) ([c64cbd7](https://github.com/telerik/kendo-theme-bootstrap/commit/c64cbd7))
* **calendar:** add styles for infinite calendar ([abee18c](https://github.com/telerik/kendo-theme-bootstrap/commit/abee18c))
* **calendar:** update calendar appearance in accordance to Bootstrap v4 beta-1 ([5779cd9](https://github.com/telerik/kendo-theme-bootstrap/commit/5779cd9))
* **chart:** grid lines colors ([#102](https://github.com/telerik/kendo-theme-bootstrap/issues/102)) ([7e2361d](https://github.com/telerik/kendo-theme-bootstrap/commit/7e2361d))
* **combobox:** rtl appearance ([9970562](https://github.com/telerik/kendo-theme-bootstrap/commit/9970562))
* **combobox:** wrong border colors of focused combobox ([3774304](https://github.com/telerik/kendo-theme-bootstrap/commit/3774304))
* **common:** improve header variables ([b0b54e6](https://github.com/telerik/kendo-theme-bootstrap/commit/b0b54e6))
* **common:** update dependency to Bootstrap v4 beta-2 ([0c50b53](https://github.com/telerik/kendo-theme-bootstrap/commit/0c50b53))
* **contextmenu:** update contextmenu appearance ([a416da7](https://github.com/telerik/kendo-theme-bootstrap/commit/a416da7))
* **dateinput:** border, hover and focus state ([08b753c](https://github.com/telerik/kendo-theme-bootstrap/commit/08b753c))
* **dateinputs:** apply consistent header styles ([c2b7d5f](https://github.com/telerik/kendo-theme-bootstrap/commit/c2b7d5f))
* **datetimepicker:** wrong focus state borders colors ([687c955](https://github.com/telerik/kendo-theme-bootstrap/commit/687c955))
* **dropdown:** add focus state to dropdown and popup ([9ce99ab](https://github.com/telerik/kendo-theme-bootstrap/commit/9ce99ab))
* **dropdownlist:** apply color to option label border ([ececc25](https://github.com/telerik/kendo-theme-bootstrap/commit/ececc25))
* **editors:** common layout glitches ([5b588d2](https://github.com/telerik/kendo-theme-bootstrap/commit/5b588d2))
* **forms:** align forms in dialog labels. ([61c881d](https://github.com/telerik/kendo-theme-bootstrap/commit/61c881d))
* **gantt:** improve milestone appearance ([df7c9a1](https://github.com/telerik/kendo-theme-bootstrap/commit/df7c9a1))
* **gantt:** make task resize handler wider and transparent ([af62568](https://github.com/telerik/kendo-theme-bootstrap/commit/af62568))
* **gantt:** reduce padding of toolbar-like elements in gantt ([fd945e2](https://github.com/telerik/kendo-theme-bootstrap/commit/fd945e2))
* **gantt:** view switcher is missing selected state ([2c19585](https://github.com/telerik/kendo-theme-bootstrap/commit/2c19585))
* **grid:** Add dirty cell indicator styling ([e75eca0](https://github.com/telerik/kendo-theme-bootstrap/commit/e75eca0))
* **grid:** Add missing locked footer border color ([e5caf33](https://github.com/telerik/kendo-theme-bootstrap/commit/e5caf33))
* **grid:** Add RTL styles for dirty cells ([266ebc7](https://github.com/telerik/kendo-theme-bootstrap/commit/266ebc7))
* **grid:** border color ([1923fff](https://github.com/telerik/kendo-theme-bootstrap/commit/1923fff))
* **grid:** Fix edit textbox width variable ([598e451](https://github.com/telerik/kendo-theme-bootstrap/commit/598e451))
* **grid:** improve grid row selected state ([1150dad](https://github.com/telerik/kendo-theme-bootstrap/commit/1150dad))
* **grid:** reduce padding of toolbar-like elements in grid ([cf25e3c](https://github.com/telerik/kendo-theme-bootstrap/commit/cf25e3c))
* **grid:** remove focus on header links ([96637a2](https://github.com/telerik/kendo-theme-bootstrap/commit/96637a2))
* **grid:** Remove selection column checkbox margin in RTL ([c671f29](https://github.com/telerik/kendo-theme-bootstrap/commit/c671f29))
* **grid:** scope selcted styles ([be070f9](https://github.com/telerik/kendo-theme-bootstrap/commit/be070f9))
* **grid:** Set fixed font-size of col sorting index to achieve alignment ([e8aef0b](https://github.com/telerik/kendo-theme-bootstrap/commit/e8aef0b))
* **grid:** Tweak multiple column sorting index position ([787d70e](https://github.com/telerik/kendo-theme-bootstrap/commit/787d70e))
* **grid:** use scoped grid variables ([7c12b76](https://github.com/telerik/kendo-theme-bootstrap/commit/7c12b76))
* **Grid:** Add cell focused state styles ([0c3fd96](https://github.com/telerik/kendo-theme-bootstrap/commit/0c3fd96))
* **Grid:** Add styles for verification tooltip ([c2b1f8a](https://github.com/telerik/kendo-theme-bootstrap/commit/c2b1f8a))
* **input:** Add styles for placeholder text ([9ea8b70](https://github.com/telerik/kendo-theme-bootstrap/commit/9ea8b70))
* **inputs:** wrong border color for invalid inputs ([c62ea18](https://github.com/telerik/kendo-theme-bootstrap/commit/c62ea18)), closes [telerik/kendo-theme-bootstrap#289](https://github.com/telerik/kendo-theme-bootstrap/issues/289)
* **listbox:** use correct variables for listbox ([f863af3](https://github.com/telerik/kendo-theme-bootstrap/commit/f863af3))
* **ListBox:** Improve button margins temporarily ([005ce87](https://github.com/telerik/kendo-theme-bootstrap/commit/005ce87))
* **listview:** add focused state ([b5d0c07](https://github.com/telerik/kendo-theme-bootstrap/commit/b5d0c07))
* **map:** Add marker color ([c958ace](https://github.com/telerik/kendo-theme-bootstrap/commit/c958ace))
* **map:** directions navigator is not properly customized in themebuilder ([502028d](https://github.com/telerik/kendo-theme-bootstrap/commit/502028d))
* **MaskedTextbox:** Add missing invalid state border ([2b9a72b](https://github.com/telerik/kendo-theme-bootstrap/commit/2b9a72b))
* **mediaplayer:** add opacity to toolbar ([d0aa7bc](https://github.com/telerik/kendo-theme-bootstrap/commit/d0aa7bc))
* **menu:** add styles for scrolling ([aa4a878](https://github.com/telerik/kendo-theme-bootstrap/commit/aa4a878))
* **multiselect:** border color ([d620f57](https://github.com/telerik/kendo-theme-bootstrap/commit/d620f57))
* **multiselect:** improve height of token with empty string telerik/kendo-ui-core[#372](https://github.com/telerik/kendo-theme-bootstrap/issues/372) ([a050374](https://github.com/telerik/kendo-theme-bootstrap/commit/a050374))
* **multiselect:** wrong items height ([a5c6116](https://github.com/telerik/kendo-theme-bootstrap/commit/a5c6116))
* **notification:** use panel styles for default type ([91ca341](https://github.com/telerik/kendo-theme-bootstrap/commit/91ca341))
* **notification:** use scoped variables for notification ([96b2c2c](https://github.com/telerik/kendo-theme-bootstrap/commit/96b2c2c))
* **numerictextbox:** spinners misalignment ([d89d006](https://github.com/telerik/kendo-theme-bootstrap/commit/d89d006))
* **pager:** add focus outline for pager buttons ([316ff9b](https://github.com/telerik/kendo-theme-bootstrap/commit/316ff9b))
* **pager:** focused state text decoration ([82fa821](https://github.com/telerik/kendo-theme-bootstrap/commit/82fa821))
* **pager:** improve disabled state of pager items ([18922d1](https://github.com/telerik/kendo-theme-bootstrap/commit/18922d1))
* **pager:** improve selected styles ([86b5726](https://github.com/telerik/kendo-theme-bootstrap/commit/86b5726))
* **pager:** use consistent header appearance ([a6ae6cd](https://github.com/telerik/kendo-theme-bootstrap/commit/a6ae6cd))
* **pager:** use relative units for button metrics ([#267](https://github.com/telerik/kendo-theme-bootstrap/issues/267)) ([bc5d7d3](https://github.com/telerik/kendo-theme-bootstrap/commit/bc5d7d3))
* **panelbar:** improve focus state ([54497f8](https://github.com/telerik/kendo-theme-bootstrap/commit/54497f8))
* **panelbar:** use correct border color for root items ([7dd7582](https://github.com/telerik/kendo-theme-bootstrap/commit/7dd7582))
* **pivotgrid:** apply header-bg to pivotgrid configurator ([381406a](https://github.com/telerik/kendo-theme-bootstrap/commit/381406a))
* **pivotgrid:** reduce padding of toolbar-like elements in pivotgrid ([8af6287](https://github.com/telerik/kendo-theme-bootstrap/commit/8af6287))
* **pivotgrid:** use correct color for pivotgrid toolbar border ([9f0fb06](https://github.com/telerik/kendo-theme-bootstrap/commit/9f0fb06))
* **Popup:** Remove the top and bottom padding of Popup when used as a column menu ([5b0ed95](https://github.com/telerik/kendo-theme-bootstrap/commit/5b0ed95))
* **progressbar:** add styles for indetermined progressbar ([e13a6c4](https://github.com/telerik/kendo-theme-bootstrap/commit/e13a6c4))
* **progressbar:** use correct variables for progressbar ([7bcdc0c](https://github.com/telerik/kendo-theme-bootstrap/commit/7bcdc0c))
* **ripple:** add default ripple styles ([19d1c09](https://github.com/telerik/kendo-theme-bootstrap/commit/19d1c09))
* **scheduler:** add bacground to event with no resources ([5fa6a29](https://github.com/telerik/kendo-theme-bootstrap/commit/5fa6a29))
* **scheduler:** view switcher is missing selected state ([9abcf35](https://github.com/telerik/kendo-theme-bootstrap/commit/9abcf35))
* **scrollview:** add styles for scrollview pager ([e79ecb8](https://github.com/telerik/kendo-theme-bootstrap/commit/e79ecb8))
* **slider:** add focus state to drag handle ([8208d0a](https://github.com/telerik/kendo-theme-bootstrap/commit/8208d0a))
* **slider:** add tick images ([80ed313](https://github.com/telerik/kendo-theme-bootstrap/commit/80ed313))
* **slider:** link slider variables to progressbar variables ([0ede195](https://github.com/telerik/kendo-theme-bootstrap/commit/0ede195))
* **slider:** remove browser outline on focus ([dc7fd03](https://github.com/telerik/kendo-theme-bootstrap/commit/dc7fd03))
* **splitter:** use correct colors for splitter ([2ff9472](https://github.com/telerik/kendo-theme-bootstrap/commit/2ff9472))
* **spreadsheet:** add styles for filter menu and filter button ([05ea173](https://github.com/telerik/kendo-theme-bootstrap/commit/05ea173))
* **spreadsheet:** improve spreadsheet active cell border by frozen cells telerik/kendo-ui-core[#3254](https://github.com/telerik/kendo-theme-bootstrap/issues/3254) ([0d838c3](https://github.com/telerik/kendo-theme-bootstrap/commit/0d838c3))
* **spreadsheet:** make drag handle to be visible in all cases telerik/kendo-ui-core[#3254](https://github.com/telerik/kendo-theme-bootstrap/issues/3254) ([4fdeafc](https://github.com/telerik/kendo-theme-bootstrap/commit/4fdeafc))
* **spreadsheet:** missing indicators for spreadsheet ([18ff11d](https://github.com/telerik/kendo-theme-bootstrap/commit/18ff11d))
* **spreadsheet:** styles for spreadsheet toolbar ([7e51ad7](https://github.com/telerik/kendo-theme-bootstrap/commit/7e51ad7))
* **switch:** border-color of switch is too dark ([1659185](https://github.com/telerik/kendo-theme-bootstrap/commit/1659185))
* wrong border color of input in scheduler advanced form ([eaf5e48](https://github.com/telerik/kendo-theme-bootstrap/commit/eaf5e48))
* **switch:** use correct border-radius for switch wrapper ([11f697e](https://github.com/telerik/kendo-theme-bootstrap/commit/11f697e))
* **tabstrip:** update variables to reflect changes in bootstrap ([fc60359](https://github.com/telerik/kendo-theme-bootstrap/commit/fc60359))
* **tabstrip:** use correct border-color when hovering / selecting tabs ([66709a7](https://github.com/telerik/kendo-theme-bootstrap/commit/66709a7))
* **timepicker:** improve popup appearance ([#348](https://github.com/telerik/kendo-theme-bootstrap/issues/348)) ([19e3965](https://github.com/telerik/kendo-theme-bootstrap/commit/19e3965))
* **tooltip:** tooltip cannot be customized in theme builder ([8e220c7](https://github.com/telerik/kendo-theme-bootstrap/commit/8e220c7))
* **tooltip:** use $font-size-sm ([c40001f](https://github.com/telerik/kendo-theme-bootstrap/commit/c40001f))
* **tooltip:** use alert-padding for close button ([2b130c7](https://github.com/telerik/kendo-theme-bootstrap/commit/2b130c7))
* **tooltip:** use contrast function to determine text color based on background ([6bc6c12](https://github.com/telerik/kendo-theme-bootstrap/commit/6bc6c12))
* **tooltip:** use correct padding for collapsible tooltip ([20ec0ad](https://github.com/telerik/kendo-theme-bootstrap/commit/20ec0ad))
* **tooltip:** use tooltip font-size variable ([53b2864](https://github.com/telerik/kendo-theme-bootstrap/commit/53b2864))
* **treeview:** add additional spacing around nodes so box shadow dont overlap ([260a216](https://github.com/telerik/kendo-theme-bootstrap/commit/260a216))
* **treeview:** add border radius to nodes ([184301c](https://github.com/telerik/kendo-theme-bootstrap/commit/184301c))
* **treeview:** focused and selected-focused state are clipped ([56e9445](https://github.com/telerik/kendo-theme-bootstrap/commit/56e9445))
* **treeview:** improve node colors ([9885066](https://github.com/telerik/kendo-theme-bootstrap/commit/9885066))
* **treeview:** reduce spacing between checkbox and item text ([b6426fc](https://github.com/telerik/kendo-theme-bootstrap/commit/b6426fc))
* **upload:** import theme styles from the default theme ([6e330aa](https://github.com/telerik/kendo-theme-bootstrap/commit/6e330aa))
* **window:** add spacing between buttons ([cbd9223](https://github.com/telerik/kendo-theme-bootstrap/commit/cbd9223))
* **window:** fix content bleeding outside of window boundaries ([932c9a7](https://github.com/telerik/kendo-theme-bootstrap/commit/932c9a7))
* **window:** increase window actions padding ([0709998](https://github.com/telerik/kendo-theme-bootstrap/commit/0709998))
* **window:** reduce window action size ([e450346](https://github.com/telerik/kendo-theme-bootstrap/commit/e450346))
* use Listing D:\WORK\kendo-ui\kendo-theme-bootstrap\ New files added to this directory will not be compressed. ([ca44855](https://github.com/telerik/kendo-theme-bootstrap/commit/ca44855))
* **window:** remove box shadow ([2331805](https://github.com/telerik/kendo-theme-bootstrap/commit/2331805))
* switch appearance ([24bb58e](https://github.com/telerik/kendo-theme-bootstrap/commit/24bb58e))
* switch label alignment ([0233b20](https://github.com/telerik/kendo-theme-bootstrap/commit/0233b20))
* Switch to a variable from pixels for font-size of col sorting index text ([55d1140](https://github.com/telerik/kendo-theme-bootstrap/commit/55d1140))
* Switch to separate vars for alert vertical / horizontal padding ([8976522](https://github.com/telerik/kendo-theme-bootstrap/commit/8976522))
* unify design of dialog buttons and action buttons ([a8b8f21](https://github.com/telerik/kendo-theme-bootstrap/commit/a8b8f21))
* unify theme entrypoint name ([1e11ce0](https://github.com/telerik/kendo-theme-bootstrap/commit/1e11ce0))
* update dependencies on build ([c2f835f](https://github.com/telerik/kendo-theme-bootstrap/commit/c2f835f))
* update license ([#277](https://github.com/telerik/kendo-theme-bootstrap/issues/277)) ([f8a0fab](https://github.com/telerik/kendo-theme-bootstrap/commit/f8a0fab))
* update spacer-x / y variables ([9987287](https://github.com/telerik/kendo-theme-bootstrap/commit/9987287))
* update variables for themebuilder ([a7cafcc](https://github.com/telerik/kendo-theme-bootstrap/commit/a7cafcc))
* use ~ paths to reference node_modules ([7bfa24d](https://github.com/telerik/kendo-theme-bootstrap/commit/7bfa24d))
* use bootstrap component-* variables for theme base variables ([130b46f](https://github.com/telerik/kendo-theme-bootstrap/commit/130b46f))
* use box sizing for autocomplete ([0ccb3e8](https://github.com/telerik/kendo-theme-bootstrap/commit/0ccb3e8))
* use correct import path for media player ([fc7ef6f](https://github.com/telerik/kendo-theme-bootstrap/commit/fc7ef6f))
* use correct selectors for focused state ([fec9aae](https://github.com/telerik/kendo-theme-bootstrap/commit/fec9aae))
* use correct values for grid-padding and toolbar-padding ([3b1656a](https://github.com/telerik/kendo-theme-bootstrap/commit/3b1656a))
* use new contrast function ([6df8a35](https://github.com/telerik/kendo-theme-bootstrap/commit/6df8a35))
* use new contrast function ([c8936af](https://github.com/telerik/kendo-theme-bootstrap/commit/c8936af))
* use the correct box sizing for pager ([b939a69](https://github.com/telerik/kendo-theme-bootstrap/commit/b939a69))
* **window:** use correct border color for window ([23f90ff](https://github.com/telerik/kendo-theme-bootstrap/commit/23f90ff))
* use the correct box-sizing for colorpicker ([13233f1](https://github.com/telerik/kendo-theme-bootstrap/commit/13233f1))
* use the correct box-sizing for slider ([e572252](https://github.com/telerik/kendo-theme-bootstrap/commit/e572252))
* **window:** use opacity for window action buttons ([edc9733](https://github.com/telerik/kendo-theme-bootstrap/commit/edc9733))
* **window:** use scoped variables for window ([d56f591](https://github.com/telerik/kendo-theme-bootstrap/commit/d56f591))
* varibles are not properly set ([b3257c9](https://github.com/telerik/kendo-theme-bootstrap/commit/b3257c9))
* various editor fixes ([f16bfbe](https://github.com/telerik/kendo-theme-bootstrap/commit/f16bfbe))
* various fixes in navigation control ([f8ad8f7](https://github.com/telerik/kendo-theme-bootstrap/commit/f8ad8f7))


### Features

* add fill and outline utility mixins ([0e003c7](https://github.com/telerik/kendo-theme-bootstrap/commit/0e003c7))
* Add ListBox styles ([f372ac9](https://github.com/telerik/kendo-theme-bootstrap/commit/f372ac9))
* add media player ([f68e2f5](https://github.com/telerik/kendo-theme-bootstrap/commit/f68e2f5))
* add pivotgrid styles ([e777abf](https://github.com/telerik/kendo-theme-bootstrap/commit/e777abf))
* **button:** add styles for outline button ([b87efdc](https://github.com/telerik/kendo-theme-bootstrap/commit/b87efdc))
* add styles for dialog component ([9401341](https://github.com/telerik/kendo-theme-bootstrap/commit/9401341))
* add styles for gantt ([d463033](https://github.com/telerik/kendo-theme-bootstrap/commit/d463033))
* Add styles for inline Editor ([33f4422](https://github.com/telerik/kendo-theme-bootstrap/commit/33f4422))
* add styles for map ([f7ee367](https://github.com/telerik/kendo-theme-bootstrap/commit/f7ee367))
* add styles for spreadsheet closes [#47](https://github.com/telerik/kendo-theme-bootstrap/issues/47) ([8555777](https://github.com/telerik/kendo-theme-bootstrap/commit/8555777))
* add styling for forms ([#268](https://github.com/telerik/kendo-theme-bootstrap/issues/268)) ([5f65bfe](https://github.com/telerik/kendo-theme-bootstrap/commit/5f65bfe))
* add support for ng-chart colors ([1645717](https://github.com/telerik/kendo-theme-bootstrap/commit/1645717))
* embed dependencies during publish ([2b77ef9](https://github.com/telerik/kendo-theme-bootstrap/commit/2b77ef9))
* enable development channel ([0543ec3](https://github.com/telerik/kendo-theme-bootstrap/commit/0543ec3))
* extract dropdown wrap ([c51f240](https://github.com/telerik/kendo-theme-bootstrap/commit/c51f240))
* publish package with [@progress](https://github.com/progress) prefix ([5c7a061](https://github.com/telerik/kendo-theme-bootstrap/commit/5c7a061))
* remove 'base' mixin folder ([f230f4e](https://github.com/telerik/kendo-theme-bootstrap/commit/f230f4e))
* remove box-sizing override to better comply with 3rd party frameworks ([540e8d1](https://github.com/telerik/kendo-theme-bootstrap/commit/540e8d1))
* standartize folder structure ([e193234](https://github.com/telerik/kendo-theme-bootstrap/commit/e193234))
* styles for barcode and qrcode ([c852789](https://github.com/telerik/kendo-theme-bootstrap/commit/c852789))
* styles for scheduler ([a67afec](https://github.com/telerik/kendo-theme-bootstrap/commit/a67afec))
* styles for scrollview ([fdd5738](https://github.com/telerik/kendo-theme-bootstrap/commit/fdd5738))
* styles for table alignment and media player ([8d65e31](https://github.com/telerik/kendo-theme-bootstrap/commit/8d65e31))
* tie bootstrap dep to a specific commit (latest as of 2017/03/06) ([fd7c42e](https://github.com/telerik/kendo-theme-bootstrap/commit/fd7c42e))
* update bootstrap dependency to 4.0.0-beta ([#299](https://github.com/telerik/kendo-theme-bootstrap/issues/299)) ([2a99728](https://github.com/telerik/kendo-theme-bootstrap/commit/2a99728))
* **grid:** style grid filter button states ([543bbe9](https://github.com/telerik/kendo-theme-bootstrap/commit/543bbe9))
* update bootstrap dependency to v4.0.0 ([3f739c8](https://github.com/telerik/kendo-theme-bootstrap/commit/3f739c8))
* **badge:** add styles for badge telerik/kendo[#7846](https://github.com/telerik/kendo-theme-bootstrap/issues/7846) ([7cd13d2](https://github.com/telerik/kendo-theme-bootstrap/commit/7cd13d2))
* **button:** add styles for bare button ([ca29995](https://github.com/telerik/kendo-theme-bootstrap/commit/ca29995))
* **button:** add styles for flat button ([2b299b7](https://github.com/telerik/kendo-theme-bootstrap/commit/2b299b7))
* **button:** add styles for outline button ([ed1f492](https://github.com/telerik/kendo-theme-bootstrap/commit/ed1f492))
* **calendar:** implement design for kendo-angular ([73268ec](https://github.com/telerik/kendo-theme-bootstrap/commit/73268ec))
* **checkbox:** improve styles for checkboxes ([0afbdde](https://github.com/telerik/kendo-theme-bootstrap/commit/0afbdde))
* **DateInput:** Add invalid state styles ([627057c](https://github.com/telerik/kendo-theme-bootstrap/commit/627057c))
* **DatePicker:** Add DateInput invalid state ([81d3727](https://github.com/telerik/kendo-theme-bootstrap/commit/81d3727))
* **datetimepicker:** Add invalid state styles ([1a14bfa](https://github.com/telerik/kendo-theme-bootstrap/commit/1a14bfa))
* **edit-form:** add styles for edit form ([16a157c](https://github.com/telerik/kendo-theme-bootstrap/commit/16a157c))
* **grid:** Add styles for column sorting ([55abc0e](https://github.com/telerik/kendo-theme-bootstrap/commit/55abc0e))
* **Grid:** Add styles for Grid column sorting order ([85cdfb9](https://github.com/telerik/kendo-theme-bootstrap/commit/85cdfb9))
* **MaskedTextbox:** Add separate styles for MTB, invalid state (telerik/kendo[#6825](https://github.com/telerik/kendo-theme-bootstrap/issues/6825)) ([d1067b0](https://github.com/telerik/kendo-theme-bootstrap/commit/d1067b0))
* **numerictextbox:** add pressed state to increase/decrease arrows; align spinner icons ([47fa757](https://github.com/telerik/kendo-theme-bootstrap/commit/47fa757))
* **radiobutton:** improve styles for radio button ([1a6db60](https://github.com/telerik/kendo-theme-bootstrap/commit/1a6db60))
* **timepicker:** Add invalid state styles ([e22dd7f](https://github.com/telerik/kendo-theme-bootstrap/commit/e22dd7f))
* use mixins from [@telerik](https://github.com/telerik)/kendo-theme-default ([ed4c3d9](https://github.com/telerik/kendo-theme-bootstrap/commit/ed4c3d9))
* use pickerwrap for combo and dropdown ([85ed82d](https://github.com/telerik/kendo-theme-bootstrap/commit/85ed82d))


### BREAKING CHANGES

* Publish with @progress prefix
