/**
 * @license
 * Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import { FirebaseApp } from '@firebase/app-types';
import { Provider } from '@firebase/component';
import { CustomProviderOptions } from '../../app-check-types';
import { AppCheckTokenInternal } from './state';
export interface AppCheckProviderInternal {
    /**
     * Returns an AppCheck token.
     */
    getToken(): Promise<AppCheckTokenInternal>;
    /**
     * Initialize the class once app and platformLoggerProvider are available.
     */
    initialize(app: FirebaseApp, platformLoggerProvider: Provider<'platform-logger'>): void;
}
/**
 * App Check provider that can obtain a reCAPTCHA V3 token and exchange it
 * for an App Check token.
 */
export declare class ReCaptchaV3Provider implements AppCheckProviderInternal {
    private _siteKey;
    private _app?;
    private _platformLoggerProvider?;
    /**
     * Create a ReCaptchaV3Provider instance.
     * @param siteKey - ReCAPTCHA V3 siteKey.
     */
    constructor(_siteKey: string);
    /**
     * Returns an App Check token.
     * @internal
     */
    getToken(): Promise<AppCheckTokenInternal>;
    initialize(app: FirebaseApp, platformLoggerProvider: Provider<'platform-logger'>): void;
}
/**
 * Custom provider class.
 */
export declare class CustomProvider implements AppCheckProviderInternal {
    private _customProviderOptions;
    private _app?;
    constructor(_customProviderOptions: CustomProviderOptions);
    /**
     * @internal
     */
    getToken(): Promise<AppCheckTokenInternal>;
    /**
     * @internal
     */
    initialize(app: FirebaseApp): void;
}
